/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.GroovyObject;
import lombok.Generated;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class WatchableGroovyScriptResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchableGroovyScriptResource.class);
    private final transient FileWatcherService watcherService;
    private final transient Resource resource;
    private transient GroovyObject groovyScript;

    public WatchableGroovyScriptResource(Resource script) {
        this.resource = script;
        if (ResourceUtils.doesResourceExist(script)) {
            this.watcherService = new FileWatcherService(script.getFile(), file -> {
                try {
                    LOGGER.debug("Reloading script at [{}]", file);
                    this.compileScriptResource(script);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            });
            this.watcherService.start(script.getFilename());
            this.compileScriptResource(script);
        } else {
            this.watcherService = null;
        }
    }

    private void compileScriptResource(Resource script) {
        this.groovyScript = ScriptingUtils.parseGroovyScript(script, true);
    }

    public <T> T execute(Object[] args, Class<T> clazz) {
        if (this.groovyScript != null) {
            return ScriptingUtils.executeGroovyScript(this.groovyScript, args, clazz, true);
        }
        return null;
    }

    @Generated
    public FileWatcherService getWatcherService() {
        return this.watcherService;
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }

    @Generated
    public GroovyObject getGroovyScript() {
        return this.groovyScript;
    }
}

