/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.spring;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ApplicationContextProvider
implements ApplicationContextAware,
ResourceLoaderAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextProvider.class);
    private static ApplicationContext CONTEXT;
    private static ResourceLoader RESOURCE_LOADER;

    public static ApplicationContext getApplicationContext() {
        return CONTEXT;
    }

    public static <T> T registerBeanIntoApplicationContext(ConfigurableApplicationContext applicationContext, Class<T> beanClazz, String beanId) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Object provider = beanFactory.createBean(beanClazz);
        beanFactory.initializeBean(provider, beanId);
        beanFactory.autowireBean(provider);
        beanFactory.registerSingleton(beanId, provider);
        return (T)provider;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        CONTEXT = ctx;
    }

    public ConfigurableApplicationContext getConfigurableApplicationContext() {
        return (ConfigurableApplicationContext)CONTEXT;
    }

    public static ResourceLoader getResourceLoader() {
        return RESOURCE_LOADER;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        RESOURCE_LOADER = resourceLoader;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() {
        return this.getConfigurableApplicationContext().getAutowireCapableBeanFactory();
    }
}

