/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.ViewProperties;
import org.apereo.cas.web.view.ChainingTemplateViewResolver;
import org.apereo.cas.web.view.RestfulUrlTemplateResolver;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;

@Configuration(value="casCoreWebViewsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreViewsConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreViewsConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ThymeleafProperties thymeleafProperties;

    @Bean
    public AbstractTemplateResolver chainingTemplateViewResolver() {
        ChainingTemplateViewResolver chain = new ChainingTemplateViewResolver();
        List templatePrefixes = this.casProperties.getView().getTemplatePrefixes();
        templatePrefixes.forEach(Unchecked.consumer(prefix -> {
            String prefixPath = ResourceUtils.getFile((String)prefix).getCanonicalPath();
            String viewPath = StringUtils.appendIfMissing((String)prefixPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            ViewProperties.Rest rest = this.casProperties.getView().getRest();
            if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
                RestfulUrlTemplateResolver url = new RestfulUrlTemplateResolver(this.casProperties);
                this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)url);
                chain.addResolver((AbstractTemplateResolver)url);
            }
            ThemeFileTemplateResolver theme = new ThemeFileTemplateResolver(this.casProperties);
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)theme);
            theme.setPrefix(viewPath + "themes/%s/");
            chain.addResolver((AbstractTemplateResolver)theme);
            FileTemplateResolver file = new FileTemplateResolver();
            this.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)file);
            file.setPrefix(viewPath);
            chain.addResolver((AbstractTemplateResolver)file);
        }));
        chain.initialize();
        return chain;
    }

    private void configureTemplateViewResolver(AbstractConfigurableTemplateResolver resolver) {
        resolver.setCacheable(this.thymeleafProperties.isCache());
        resolver.setCharacterEncoding(this.thymeleafProperties.getEncoding().name());
        resolver.setCheckExistence(this.thymeleafProperties.isCheckTemplateLocation());
        resolver.setForceTemplateMode(true);
        resolver.setOrder(Integer.valueOf(0));
        resolver.setSuffix(".html");
        resolver.setTemplateMode(this.thymeleafProperties.getMode());
    }
}

