/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.model.core.web.MessageBundleProperties;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.view.CasReloadableMessageBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

@Configuration(value="casCoreWebConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreWebConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreWebConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public PropertiesFactoryBean casCommonMessages() {
        PropertiesFactoryBean properties = new PropertiesFactoryBean();
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        List commonNames = this.casProperties.getMessageBundle().getCommonNames();
        List<Resource> resourceList = commonNames.stream().map(arg_0 -> ((DefaultResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toList());
        resourceList.add(resourceLoader.getResource("classpath:/cas_common_messages.properties"));
        properties.setLocations(resourceList.toArray(new Resource[0]));
        properties.setSingleton(true);
        properties.setIgnoreResourceNotFound(true);
        return properties;
    }

    @RefreshScope
    @Bean
    public HierarchicalMessageSource messageSource(@Qualifier(value="casCommonMessages") Properties casCommonMessages) {
        CasReloadableMessageBundle bean = new CasReloadableMessageBundle();
        MessageBundleProperties mb = this.casProperties.getMessageBundle();
        bean.setDefaultEncoding(mb.getEncoding());
        bean.setCacheSeconds(mb.getCacheSeconds());
        bean.setFallbackToSystemLocale(mb.isFallbackSystemLocale());
        bean.setUseCodeAsDefaultMessage(mb.isUseCodeMessage());
        bean.setBasenames(mb.getBaseNames().toArray(new String[0]));
        bean.setCommonMessages(casCommonMessages);
        return bean;
    }

    @Autowired
    @Bean
    public ArgumentExtractor argumentExtractor(List<ServiceFactoryConfigurer> configurers) {
        ArrayList serviceFactoryList = new ArrayList();
        configurers.forEach(c -> serviceFactoryList.addAll(c.buildServiceFactories()));
        AnnotationAwareOrderComparator.sortIfNecessary(serviceFactoryList);
        return new DefaultArgumentExtractor(serviceFactoryList);
    }

    @Bean
    public FactoryBean<UrlValidator> urlValidator() {
        HttpClientProperties httpClient = this.casProperties.getHttpClient();
        boolean allowLocalLogoutUrls = httpClient.isAllowLocalLogoutUrls();
        String authorityValidationRegEx = httpClient.getAuthorityValidationRegEx();
        boolean authorityValidationRegExCaseSensitive = httpClient.isAuthorityValidationRegExCaseSensitive();
        return new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls, authorityValidationRegEx, authorityValidationRegExCaseSensitive);
    }
}

