/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.view;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractCasView
extends AbstractView {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasView.class);
    protected final boolean successResponse;
    protected final ProtocolAttributeEncoder protocolAttributeEncoder;
    protected final ServicesManager servicesManager;
    protected final String authenticationContextAttribute;
    protected final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;

    protected Assertion getAssertionFrom(Map<String, Object> model) {
        return (Assertion)model.get("assertion");
    }

    protected String getErrorCodeFrom(Map<String, Object> model) {
        return model.get("code").toString();
    }

    protected String getErrorDescriptionFrom(Map<String, Object> model) {
        return model.get("description").toString();
    }

    protected String getProxyGrantingTicketId(Map<String, Object> model) {
        return (String)model.get("proxyGrantingTicket");
    }

    protected String getProxyGrantingTicketIou(Map<String, Object> model) {
        return (String)model.get("pgtIou");
    }

    protected Authentication getPrimaryAuthenticationFrom(Map<String, Object> model) {
        return this.getAssertionFrom(model).getPrimaryAuthentication();
    }

    protected Map<String, Object> getModelAttributes(Map<String, Object> model) {
        return (Map)model.get("attributes");
    }

    protected Map<String, Object> getAuthenticationAttributes(Map<String, Object> model) {
        Authentication authn = this.getPrimaryAuthenticationFrom(model);
        return authn.getAttributes();
    }

    protected String getAuthenticationAttribute(Map<String, Object> model, String attributeName) {
        Authentication authn = this.getPrimaryAuthenticationFrom(model);
        Optional element = CollectionUtils.firstElement(authn.getAttributes().get(attributeName));
        if (element.isPresent()) {
            return element.get().toString();
        }
        return null;
    }

    protected Principal getPrincipal(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getPrincipal();
    }

    protected Map<String, Object> getPrincipalAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return AbstractCasView.convertAttributeValuesToMultiValuedObjects(this.getPrincipal(model).getAttributes());
    }

    protected Map<String, Object> getAuthenticationAttributesAsMultiValuedAttributes(Map<String, Object> model) {
        return AbstractCasView.convertAttributeValuesToMultiValuedObjects(this.getPrimaryAuthenticationFrom(model).getAttributes());
    }

    protected boolean isRememberMeAuthentication(Map<String, Object> model) {
        Map<String, Object> authnAttributes = this.getAuthenticationAttributesAsMultiValuedAttributes(model);
        Collection authnMethod = (Collection)authnAttributes.get("org.apereo.cas.authentication.principal.REMEMBER_ME");
        return authnMethod != null && authnMethod.contains(Boolean.TRUE) && this.isAssertionBackedByNewLogin(model);
    }

    protected String getSatisfiedMultifactorAuthenticationProviderId(Map<String, Object> model) {
        if (StringUtils.isNotBlank((CharSequence)this.authenticationContextAttribute) && model.containsKey(this.authenticationContextAttribute)) {
            return model.get(this.authenticationContextAttribute).toString();
        }
        return null;
    }

    protected boolean isAssertionBackedByNewLogin(Map<String, Object> model) {
        return this.getAssertionFrom(model).isFromNewLogin();
    }

    private static Map<String, Object> convertAttributeValuesToMultiValuedObjects(Map<String, Object> attributes) {
        Set<Map.Entry<String, Object>> entries = attributes.entrySet();
        return entries.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof Collection || value instanceof Map || value instanceof Object[] || value instanceof Iterator || value instanceof Enumeration) {
                return value;
            }
            return CollectionUtils.wrap(value);
        }));
    }

    protected ZonedDateTime getAuthenticationDate(Map<String, Object> model) {
        return this.getPrimaryAuthenticationFrom(model).getAuthenticationDate();
    }

    protected Service getServiceFrom(Map<String, Object> model) {
        return (Service)model.get("service");
    }

    protected Collection<Authentication> getChainedAuthentications(Map<String, Object> model) {
        Assertion assertion = this.getAssertionFrom(model);
        List chainedAuthentications = assertion.getChainedAuthentications();
        return chainedAuthentications.stream().limit(chainedAuthentications.size() - 1).collect(Collectors.toList());
    }

    protected void decideIfCredentialPasswordShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseCredentialPassword();
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getAuthenticationAttribute(model, "credential"), "credential", service, isAuthorized);
    }

    protected void decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        RegisteredServiceAttributeReleasePolicy policy = service.getAttributeReleasePolicy();
        boolean isAuthorized = policy != null && policy.isAuthorizedToReleaseProxyGrantingTicket();
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getProxyGrantingTicketId(model), "proxyGrantingTicket", service, isAuthorized);
    }

    protected void decideAttributeReleaseBasedOnServiceAttributePolicy(Map<String, Object> attributes, String attributeValue, String attributeName, RegisteredService service, boolean doesAttributePolicyAllow) {
        if (StringUtils.isNotBlank((CharSequence)attributeValue)) {
            LOGGER.debug("Obtained [{}] as an authentication attribute", (Object)attributeName);
            if (doesAttributePolicyAllow) {
                LOGGER.debug("Obtained [{}] is passed to the CAS validation payload", (Object)attributeName);
                attributes.put(attributeName, CollectionUtils.wrap((Object)attributeValue));
            } else {
                LOGGER.debug("Attribute release policy for [{}] does not authorize the release of [{}]", (Object)service.getServiceId(), (Object)attributeName);
                attributes.remove(attributeName);
            }
        } else {
            LOGGER.trace("[{}] is not available and will not be released to the validation response.", (Object)attributeName);
        }
    }

    protected void putIntoModel(Map<String, Object> model, String key, Object value) {
        LOGGER.trace("Adding attribute [{}] into the view model for [{}] with value [{}]", new Object[]{key, ((Object)((Object)this)).getClass().getSimpleName(), value});
        model.put(key, value);
    }

    protected void putAllIntoModel(Map<String, Object> model, Map<String, Object> values) {
        model.putAll(values);
    }

    @Generated
    public boolean isSuccessResponse() {
        return this.successResponse;
    }

    @Generated
    public ProtocolAttributeEncoder getProtocolAttributeEncoder() {
        return this.protocolAttributeEncoder;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public String getAuthenticationContextAttribute() {
        return this.authenticationContextAttribute;
    }

    @Generated
    public AuthenticationAttributeReleasePolicy getAuthenticationAttributeReleasePolicy() {
        return this.authenticationAttributeReleasePolicy;
    }

    @Generated
    public AbstractCasView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
        this.successResponse = successResponse;
        this.protocolAttributeEncoder = protocolAttributeEncoder;
        this.servicesManager = servicesManager;
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
    }
}

