/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.extractcert;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.extractcert.RequestHeaderX509CertificateExtractor;
import org.apereo.cas.web.extractcert.X509CertificateExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="x509CertificateExtractorConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class X509CertificateExtractorConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"x509ExtractSSLCertificate"})
    @Bean
    public X509CertificateExtractor x509ExtractSSLCertificate() {
        String sslHeaderName = this.casProperties.getAuthn().getX509().getSslHeaderName();
        return new RequestHeaderX509CertificateExtractor(sslHeaderName);
    }
}

