/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.actions.LogoutConversionService;
import org.apereo.cas.web.flow.configurer.DefaultLoginWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.DefaultLogoutWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.GroovyWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.plan.DefaultCasWebflowExecutionPlan;
import org.apereo.cas.web.flow.executor.WebflowExecutorFactory;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.webflow.config.FlowBuilderServicesBuilder;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.mvc.builder.MvcViewFactoryCreator;
import org.springframework.webflow.mvc.servlet.FlowHandlerMapping;

@Configuration(value="casWebflowContextConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebflowContextConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebflowContextConfiguration.class);
    private static final int LOGOUT_FLOW_HANDLER_ORDER = 3;
    private static final String BASE_CLASSPATH_WEBFLOW = "classpath*:/webflow";
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="authenticationThrottlingExecutionPlan")
    private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;
    @Autowired
    @Qualifier(value="registeredServiceViewResolver")
    private ObjectProvider<ViewResolver> registeredServiceViewResolver;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="webflowCipherExecutor")
    private CipherExecutor webflowCipherExecutor;

    @Bean
    public ExpressionParser expressionParser() {
        return new WebFlowSpringELExpressionParser(new SpelExpressionParser(), this.logoutConversionService());
    }

    @Bean
    public ConversionService logoutConversionService() {
        return new LogoutConversionService();
    }

    @RefreshScope
    @Bean
    public ViewFactoryCreator viewFactoryCreator() {
        MvcViewFactoryCreator resolver = new MvcViewFactoryCreator();
        resolver.setViewResolvers(CollectionUtils.wrap((Object)((ViewResolver)this.registeredServiceViewResolver.getIfAvailable())));
        return resolver;
    }

    @Bean
    public FlowUrlHandler loginFlowUrlHandler() {
        return new CasDefaultFlowUrlHandler();
    }

    @Bean
    public FlowUrlHandler logoutFlowUrlHandler() {
        CasDefaultFlowUrlHandler handler = new CasDefaultFlowUrlHandler();
        handler.setFlowExecutionKeyParameter("RelayState");
        return handler;
    }

    @RefreshScope
    @Bean
    public HandlerAdapter logoutHandlerAdapter() {
        CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("logout");
        handler.setFlowExecutor(this.logoutFlowExecutor());
        handler.setFlowUrlHandler(this.logoutFlowUrlHandler());
        return handler;
    }

    @RefreshScope
    @Bean
    public FlowBuilderServices builder() {
        FlowBuilderServicesBuilder builder = new FlowBuilderServicesBuilder();
        builder.setViewFactoryCreator(this.viewFactoryCreator());
        builder.setExpressionParser(this.expressionParser());
        builder.setDevelopmentMode(this.casProperties.getWebflow().isRefresh());
        return builder.build();
    }

    @Bean
    public HandlerAdapter loginHandlerAdapter() {
        CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("login");
        handler.setFlowExecutor(this.loginFlowExecutor());
        handler.setFlowUrlHandler(this.loginFlowUrlHandler());
        return handler;
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"localeChangeInterceptor"})
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor bean = new LocaleChangeInterceptor();
        bean.setParamName(this.casProperties.getLocale().getParamName());
        return bean;
    }

    @Bean
    public HandlerMapping logoutFlowHandlerMapping() {
        FlowHandlerMapping handler = new FlowHandlerMapping();
        handler.setOrder(3);
        handler.setFlowRegistry(this.logoutFlowRegistry());
        Object[] interceptors = new Object[]{this.localeChangeInterceptor()};
        handler.setInterceptors(interceptors);
        return handler;
    }

    @Lazy
    @Bean
    public Object[] loginFlowHandlerMappingInterceptors() {
        ArrayList<LocaleChangeInterceptor> interceptors = new ArrayList<LocaleChangeInterceptor>();
        interceptors.add(this.localeChangeInterceptor());
        AuthenticationThrottlingExecutionPlan plan = (AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getIfAvailable();
        if (plan != null) {
            interceptors.addAll(plan.getAuthenticationThrottleInterceptors());
        }
        return interceptors.toArray();
    }

    @Bean
    public HandlerMapping loginFlowHandlerMapping() {
        FlowHandlerMapping handler = new FlowHandlerMapping();
        handler.setOrder(2);
        handler.setFlowRegistry(this.loginFlowRegistry());
        handler.setInterceptors(this.loginFlowHandlerMappingInterceptors());
        return handler;
    }

    @Bean
    public FlowDefinitionRegistry logoutFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.builder());
        builder.setBasePath(BASE_CLASSPATH_WEBFLOW);
        builder.addFlowLocationPattern("/logout/*-webflow.xml");
        return builder.build();
    }

    @Bean
    public FlowDefinitionRegistry loginFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.builder());
        builder.setBasePath(BASE_CLASSPATH_WEBFLOW);
        builder.addFlowLocationPattern("/login/*-webflow.xml");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public FlowExecutor logoutFlowExecutor() {
        WebflowExecutorFactory factory = new WebflowExecutorFactory(this.casProperties.getWebflow(), this.logoutFlowRegistry(), this.webflowCipherExecutor, new FlowExecutionListener[0]);
        return factory.build();
    }

    @RefreshScope
    @Bean
    public FlowExecutor loginFlowExecutor() {
        WebflowExecutorFactory factory = new WebflowExecutorFactory(this.casProperties.getWebflow(), this.loginFlowRegistry(), this.webflowCipherExecutor, new FlowExecutionListener[0]);
        return factory.build();
    }

    @ConditionalOnMissingBean(name={"defaultWebflowConfigurer"})
    @Bean
    @Order(value=0)
    @RefreshScope
    public CasWebflowConfigurer defaultWebflowConfigurer() {
        DefaultLoginWebflowConfigurer c = new DefaultLoginWebflowConfigurer(this.builder(), this.loginFlowRegistry(), this.applicationContext, this.casProperties);
        c.setLogoutFlowDefinitionRegistry(this.logoutFlowRegistry());
        c.setOrder(Integer.MIN_VALUE);
        return c;
    }

    @ConditionalOnMissingBean(name={"defaultLogoutWebflowConfigurer"})
    @Bean
    @Order(value=0)
    @RefreshScope
    public CasWebflowConfigurer defaultLogoutWebflowConfigurer() {
        DefaultLogoutWebflowConfigurer c = new DefaultLogoutWebflowConfigurer(this.builder(), this.loginFlowRegistry(), this.applicationContext, this.casProperties);
        c.setLogoutFlowDefinitionRegistry(this.logoutFlowRegistry());
        c.setOrder(Integer.MIN_VALUE);
        return c;
    }

    @ConditionalOnMissingBean(name={"groovyWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    @RefreshScope
    public CasWebflowConfigurer groovyWebflowConfigurer() {
        GroovyWebflowConfigurer c = new GroovyWebflowConfigurer(this.builder(), this.loginFlowRegistry(), this.applicationContext, this.casProperties);
        c.setLogoutFlowDefinitionRegistry(this.logoutFlowRegistry());
        return c;
    }

    @Autowired
    @Bean
    public CasWebflowExecutionPlan casWebflowExecutionPlan(List<CasWebflowExecutionPlanConfigurer> configurers) {
        DefaultCasWebflowExecutionPlan plan = new DefaultCasWebflowExecutionPlan();
        configurers.forEach(c -> c.configureWebflowExecutionPlan((CasWebflowExecutionPlan)plan));
        plan.execute();
        return plan;
    }

    @ConditionalOnMissingBean(name={"casDefaultWebflowExecutionPlanConfigurer"})
    @Bean
    public CasWebflowExecutionPlanConfigurer casDefaultWebflowExecutionPlanConfigurer() {
        return new CasWebflowExecutionPlanConfigurer(){

            public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
                plan.registerWebflowConfigurer(CasWebflowContextConfiguration.this.defaultWebflowConfigurer());
                plan.registerWebflowConfigurer(CasWebflowContextConfiguration.this.defaultLogoutWebflowConfigurer());
                plan.registerWebflowConfigurer(CasWebflowContextConfiguration.this.groovyWebflowConfigurer());
            }
        };
    }
}

