/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationExceptionHandlerAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationExceptionHandlerAction.class);
    private static final String DEFAULT_MESSAGE_BUNDLE_PREFIX = "authenticationFailure.";
    private static final String UNKNOWN = "UNKNOWN";
    private final Set<Class<? extends Throwable>> errors;
    private String messageBundlePrefix = "authenticationFailure.";

    public AuthenticationExceptionHandlerAction() {
        this(new LinkedHashSet<Class<? extends Throwable>>());
    }

    public AuthenticationExceptionHandlerAction(Set<Class<? extends Throwable>> errors) {
        this.errors = errors;
    }

    public Set<Class<? extends Throwable>> getErrors() {
        return new LinkedHashSet<Class<? extends Throwable>>(this.errors);
    }

    public String handle(Exception e, RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        if (e instanceof AuthenticationException) {
            return this.handleAuthenticationException((AuthenticationException)e, requestContext);
        }
        if (e instanceof AbstractTicketException) {
            return this.handleAbstractTicketException((AbstractTicketException)e, requestContext);
        }
        LOGGER.trace("Unable to translate errors of the authentication exception [{}]. Returning [{}]", (Object)e, (Object)UNKNOWN);
        String messageCode = this.messageBundlePrefix + UNKNOWN;
        messageContext.addMessage(new MessageBuilder().error().code(messageCode).build());
        return UNKNOWN;
    }

    protected String handleAuthenticationException(AuthenticationException e, RequestContext requestContext) {
        URI url;
        if (e.getHandlerErrors().containsKey(UnauthorizedServiceForPrincipalException.class.getSimpleName()) && (url = WebUtils.getUnauthorizedRedirectUrlIntoFlowScope((RequestContext)requestContext)) != null) {
            LOGGER.warn("Unauthorized service access for principal; CAS will be redirecting to [{}]", (Object)url);
            return "serviceUnauthorizedCheck";
        }
        Collection values = e.getHandlerErrors().values().stream().map(Object::getClass).collect(Collectors.toList());
        String handlerErrorName = this.errors.stream().filter(values::contains).map(Class::getSimpleName).findFirst().orElseGet(() -> {
            LOGGER.debug("Unable to translate handler errors of the authentication exception [{}]. Returning [{}]", (Object)e, (Object)UNKNOWN);
            return UNKNOWN;
        });
        MessageContext messageContext = requestContext.getMessageContext();
        String messageCode = this.messageBundlePrefix + handlerErrorName;
        messageContext.addMessage(new MessageBuilder().error().code(messageCode).build());
        return handlerErrorName;
    }

    protected String handleAbstractTicketException(AbstractTicketException e, RequestContext requestContext) {
        MessageContext messageContext = requestContext.getMessageContext();
        Optional<String> match = this.errors.stream().filter(c -> c.isInstance(e)).map(Class::getSimpleName).findFirst();
        match.ifPresent(s -> messageContext.addMessage(new MessageBuilder().error().code(e.getCode()).build()));
        return match.orElse(UNKNOWN);
    }

    protected Event doExecute(RequestContext requestContext) {
        Event currentEvent = requestContext.getCurrentEvent();
        LOGGER.debug("Located current event [{}]", (Object)currentEvent);
        Exception error = (Exception)currentEvent.getAttributes().get("error", Exception.class);
        if (error != null) {
            LOGGER.debug("Located error attribute [{}] with message [{}] from the current event", error.getClass(), (Object)error.getMessage());
            String event = this.handle(error, requestContext);
            LOGGER.debug("Final event id resolved from the error is [{}]", (Object)event);
            return new EventFactorySupport().event((Object)this, event, currentEvent.getAttributes());
        }
        return new EventFactorySupport().event((Object)this, "error");
    }
}

