/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RestEndpointMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestEndpointMultifactorAuthenticationPolicyEventResolver.class);
    private final String restEndpoint;

    public RestEndpointMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authSelectionStrategies, selector);
        this.restEndpoint = casProperties.getAuthn().getMfa().getRestEndpoint();
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        Principal principal = authentication.getPrincipal();
        if (StringUtils.isBlank((CharSequence)this.restEndpoint)) {
            LOGGER.debug("Rest endpoint to determine event is not configured for [{}]", (Object)principal.getId());
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            return null;
        }
        Collection<MultifactorAuthenticationProvider> flattenedProviders = this.flattenProviders(providerMap.values());
        LOGGER.debug("Contacting [{}] to inquire about [{}]", (Object)this.restEndpoint, (Object)principal.getId());
        String results = this.callRestEndpointForMultifactor(principal, context);
        if (StringUtils.isNotBlank((CharSequence)results)) {
            return this.resolveMultifactorEventViaRestResult(results, flattenedProviders);
        }
        LOGGER.debug("No providers are available to match rest endpoint results");
        return new HashSet<Event>(0);
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }

    protected Set<Event> resolveMultifactorEventViaRestResult(String results, Collection<MultifactorAuthenticationProvider> providers) {
        LOGGER.debug("Result returned from the rest endpoint is [{}]", (Object)results);
        MultifactorAuthenticationProvider restProvider = providers.stream().filter(p -> p.matches(results)).findFirst().orElse(null);
        if (restProvider != null) {
            LOGGER.debug("Found multifactor authentication provider [{}]", (Object)restProvider.getId());
            return CollectionUtils.wrapSet((Object)new Event((Object)this, restProvider.getId()));
        }
        LOGGER.debug("No multifactor authentication provider could be matched against [{}]", (Object)results);
        return new HashSet<Event>(0);
    }

    protected String callRestEndpointForMultifactor(Principal principal, RequestContext context) {
        RestTemplate restTemplate = new RestTemplate();
        Service resolvedService = this.resolveServiceFromAuthenticationRequest(context);
        RestEndpointEntity entity = new RestEndpointEntity(principal.getId(), resolvedService.getId());
        ResponseEntity responseEntity = restTemplate.postForEntity(this.restEndpoint, (Object)entity, String.class, new Object[0]);
        if (responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK) {
            return (String)responseEntity.getBody();
        }
        return null;
    }

    @Generated
    public String getRestEndpoint() {
        return this.restEndpoint;
    }

    public static class RestEndpointEntity {
        private final String principalId;
        private final String serviceId;

        @Generated
        public String getPrincipalId() {
            return this.principalId;
        }

        @Generated
        public String getServiceId() {
            return this.serviceId;
        }

        @Generated
        public RestEndpointEntity(String principalId, String serviceId) {
            this.principalId = principalId;
            this.serviceId = serviceId;
        }

        @Generated
        public String toString() {
            return "RestEndpointMultifactorAuthenticationPolicyEventResolver.RestEndpointEntity(principalId=" + this.principalId + ", serviceId=" + this.serviceId + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RestEndpointEntity)) {
                return false;
            }
            RestEndpointEntity other = (RestEndpointEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$principalId = this.principalId;
            String other$principalId = other.principalId;
            if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
                return false;
            }
            String this$serviceId = this.serviceId;
            String other$serviceId = other.serviceId;
            return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RestEndpointEntity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $principalId = this.principalId;
            result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
            String $serviceId = this.serviceId;
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            return result;
        }
    }
}

