/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.File;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.config.CasConfigurationCreatedEvent;
import org.apereo.cas.support.events.config.CasConfigurationDeletedEvent;
import org.apereo.cas.support.events.config.CasConfigurationModifiedEvent;
import org.apereo.cas.util.function.ComposableFunction;
import org.apereo.cas.util.io.PathWatcherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration(value="casConfigurationSupportUtilitiesConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasConfigurationSupportUtilitiesConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationSupportUtilitiesConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    private final ComposableFunction<File, AbstractCasEvent> createConfigurationCreatedEvent = file -> new CasConfigurationCreatedEvent((Object)this, file.toPath());
    private final ComposableFunction<File, AbstractCasEvent> createConfigurationModifiedEvent = file -> new CasConfigurationModifiedEvent((Object)this, file.toPath());
    private final ComposableFunction<File, AbstractCasEvent> createConfigurationDeletedEvent = file -> new CasConfigurationDeletedEvent((Object)this, file.toPath());

    @Configuration(value="casCoreConfigurationWatchConfiguration")
    @Profile(value={"standalone"})
    @ConditionalOnProperty(value={"spring.cloud.config.enabled"}, havingValue="false")
    public class CasCoreConfigurationWatchConfiguration {
        @Autowired
        private ApplicationEventPublisher eventPublisher;
        @Autowired
        @Qualifier(value="configurationPropertiesEnvironmentManager")
        private CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;
        private final Consumer<AbstractCasEvent> publish = event -> this.eventPublisher.publishEvent((ApplicationEvent)event);

        @PostConstruct
        public void init() {
            this.runNativeConfigurationDirectoryPathWatchService();
        }

        public void runNativeConfigurationDirectoryPathWatchService() {
            File config = this.configurationPropertiesEnvironmentManager.getStandaloneProfileConfigurationDirectory();
            if (CasConfigurationSupportUtilitiesConfiguration.this.casProperties.getEvents().isTrackConfigurationModifications() && config.exists()) {
                LOGGER.debug("Starting to watch configuration directory [{}]", (Object)config);
                PathWatcherService watcher = new PathWatcherService(config.toPath(), CasConfigurationSupportUtilitiesConfiguration.this.createConfigurationCreatedEvent.andNext(this.publish), CasConfigurationSupportUtilitiesConfiguration.this.createConfigurationModifiedEvent.andNext(this.publish), CasConfigurationSupportUtilitiesConfiguration.this.createConfigurationDeletedEvent.andNext(this.publish));
                watcher.start(config.getName());
            } else {
                LOGGER.info("CAS is configured to NOT watch configuration directory [{}]. Changes require manual reloads/restarts.", (Object)config);
            }
        }
    }
}

