/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.naming.directory.SearchControls;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.resolvers.InternalGroovyScriptDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.GrouperPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.persondir.DefaultPersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributeScriptDao;
import org.apereo.services.persondir.support.CachingPersonAttributeDaoImpl;
import org.apereo.services.persondir.support.GroovyPersonAttributeDao;
import org.apereo.services.persondir.support.GrouperPersonAttributeDao;
import org.apereo.services.persondir.support.JsonBackedComplexStubPersonAttributeDao;
import org.apereo.services.persondir.support.MergingPersonAttributeDaoImpl;
import org.apereo.services.persondir.support.RestfulPersonAttributeDao;
import org.apereo.services.persondir.support.ScriptEnginePersonAttributeDao;
import org.apereo.services.persondir.support.jdbc.MultiRowJdbcPersonAttributeDao;
import org.apereo.services.persondir.support.jdbc.SingleRowJdbcPersonAttributeDao;
import org.apereo.services.persondir.support.ldap.LdaptivePersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.apereo.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.apereo.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.apereo.services.persondir.support.merger.ReplacingAttributeAdder;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;

@Configuration(value="casPersonDirectoryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasPersonDirectoryConfiguration
implements PersonDirectoryAttributeRepositoryPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ObjectProvider<List<PersonDirectoryAttributeRepositoryPlanConfigurer>> attributeRepositoryConfigurers;

    @ConditionalOnMissingBean(name={"attributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> attributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        list.addAll(this.ldapAttributeRepositories());
        list.addAll(this.jdbcAttributeRepositories());
        list.addAll(this.jsonAttributeRepositories());
        list.addAll(this.groovyAttributeRepositories());
        list.addAll(this.grouperAttributeRepositories());
        list.addAll(this.restfulAttributeRepositories());
        list.addAll(this.scriptedAttributeRepositories());
        list.addAll(this.stubAttributeRepositories());
        List configurers = (List)ObjectUtils.defaultIfNull((Object)((List)this.attributeRepositoryConfigurers.getIfAvailable()), new ArrayList());
        DefaultPersonDirectoryAttributeRepositoryPlan plan = new DefaultPersonDirectoryAttributeRepositoryPlan();
        configurers.forEach(c -> c.configureAttributeRepositoryPlan(plan));
        list.addAll(plan.getAttributeRepositories());
        OrderComparator.sort(list);
        LOGGER.debug("Final list of attribute repositories is [{}]", list);
        return list;
    }

    @ConditionalOnMissingBean(name={"attributeRepository"})
    @Bean
    @RefreshScope
    public IPersonAttributeDao attributeRepository() {
        return this.cachingAttributeRepository();
    }

    @ConditionalOnMissingBean(name={"jsonAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> jsonAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        this.casProperties.getAuthn().getAttributeRepository().getJson().forEach(Unchecked.consumer(json -> {
            Resource r = json.getLocation();
            if (r != null) {
                JsonBackedComplexStubPersonAttributeDao dao = new JsonBackedComplexStubPersonAttributeDao(r);
                dao.setOrder(json.getOrder());
                dao.init();
                LOGGER.debug("Configured JSON attribute sources from [{}]", (Object)r);
                list.add((IPersonAttributeDao)dao);
            }
        }));
        return list;
    }

    @ConditionalOnMissingBean(name={"groovyAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> groovyAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        this.casProperties.getAuthn().getAttributeRepository().getGroovy().forEach(groovy -> {
            if (groovy.getLocation() != null) {
                GroovyPersonAttributeDao dao = new GroovyPersonAttributeDao((IPersonAttributeScriptDao)new InternalGroovyScriptDao(this.applicationContext, this.casProperties));
                dao.setCaseInsensitiveUsername(groovy.isCaseInsensitive());
                dao.setOrder(groovy.getOrder());
                LOGGER.debug("Configured Groovy attribute sources from [{}]", (Object)groovy.getLocation());
                list.add((IPersonAttributeDao)dao);
            }
        });
        return list;
    }

    @ConditionalOnMissingBean(name={"grouperAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> grouperAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        GrouperPrincipalAttributesProperties gp = this.casProperties.getAuthn().getAttributeRepository().getGrouper();
        if (gp.isEnabled()) {
            GrouperPersonAttributeDao dao = new GrouperPersonAttributeDao();
            dao.setOrder(gp.getOrder());
            LOGGER.debug("Configured Grouper attribute source");
            list.add((IPersonAttributeDao)dao);
        }
        return list;
    }

    @ConditionalOnMissingBean(name={"stubAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> stubAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        Map attrs = this.casProperties.getAuthn().getAttributeRepository().getStub().getAttributes();
        if (!attrs.isEmpty() && list.isEmpty()) {
            LOGGER.info("Found and added static attributes [{}] to the list of candidate attribute repositories", attrs.keySet());
            list.add(Beans.newStubAttributeRepository((PrincipalAttributesProperties)this.casProperties.getAuthn().getAttributeRepository()));
        }
        return list;
    }

    @ConditionalOnMissingBean(name={"jdbcAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> jdbcAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        PrincipalAttributesProperties attrs = this.casProperties.getAuthn().getAttributeRepository();
        attrs.getJdbc().forEach(jdbc -> {
            if (StringUtils.isNotBlank((CharSequence)jdbc.getSql()) && StringUtils.isNotBlank((CharSequence)jdbc.getUrl())) {
                SingleRowJdbcPersonAttributeDao jdbcDao;
                if (jdbc.isSingleRow()) {
                    LOGGER.debug("Configured single-row JDBC attribute repository for [{}]", (Object)jdbc.getUrl());
                    jdbcDao = new SingleRowJdbcPersonAttributeDao(JpaBeans.newDataSource((AbstractJpaProperties)jdbc), jdbc.getSql());
                } else {
                    LOGGER.debug("Configured multi-row JDBC attribute repository for [{}]", (Object)jdbc.getUrl());
                    jdbcDao = new MultiRowJdbcPersonAttributeDao(JpaBeans.newDataSource((AbstractJpaProperties)jdbc), jdbc.getSql());
                    LOGGER.debug("Configured multi-row JDBC column mappings for [{}] are [{}]", (Object)jdbc.getUrl(), (Object)jdbc.getColumnMappings());
                    ((MultiRowJdbcPersonAttributeDao)jdbcDao).setNameValueColumnMappings(jdbc.getColumnMappings());
                }
                jdbcDao.setQueryAttributeMapping(CollectionUtils.wrap((String)"username", (Object)jdbc.getUsername()));
                Map mapping = jdbc.getAttributes();
                if (mapping != null && !mapping.isEmpty()) {
                    LOGGER.debug("Configured result attribute mapping for [{}] to be [{}]", (Object)jdbc.getUrl(), (Object)jdbc.getAttributes());
                    jdbcDao.setResultAttributeMapping(mapping);
                }
                jdbcDao.setRequireAllQueryAttributes(jdbc.isRequireAllAttributes());
                jdbcDao.setUsernameCaseCanonicalizationMode(jdbc.getCaseCanonicalization());
                jdbcDao.setDefaultCaseCanonicalizationMode(jdbc.getCaseCanonicalization());
                jdbcDao.setQueryType(jdbc.getQueryType());
                jdbcDao.setOrder(jdbc.getOrder());
                list.add((IPersonAttributeDao)jdbcDao);
            }
        });
        return list;
    }

    @ConditionalOnMissingBean(name={"ldapAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> ldapAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        PrincipalAttributesProperties attrs = this.casProperties.getAuthn().getAttributeRepository();
        attrs.getLdap().forEach(ldap -> {
            if (StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl())) {
                LdaptivePersonAttributeDao ldapDao = new LdaptivePersonAttributeDao();
                LOGGER.debug("Configured LDAP attribute source for [{}] and baseDn [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getBaseDn());
                ldapDao.setConnectionFactory((ConnectionFactory)LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap));
                ldapDao.setBaseDN(ldap.getBaseDn());
                LOGGER.debug("LDAP attributes are fetched from [{}] via filter [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getSearchFilter());
                ldapDao.setSearchFilter(ldap.getSearchFilter());
                SearchControls constraints = new SearchControls();
                if (ldap.getAttributes() != null && !ldap.getAttributes().isEmpty()) {
                    LOGGER.debug("Configured result attribute mapping for [{}] to be [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getAttributes());
                    ldapDao.setResultAttributeMapping(ldap.getAttributes());
                    String[] attributes = ldap.getAttributes().keySet().toArray(new String[ldap.getAttributes().keySet().size()]);
                    constraints.setReturningAttributes(attributes);
                } else {
                    LOGGER.debug("Retrieving all attributes as no explicit attribute mappings are defined for [{}]", (Object)ldap.getLdapUrl());
                    constraints.setReturningAttributes(null);
                }
                if (ldap.isSubtreeSearch()) {
                    LOGGER.debug("Configured subtree searching for [{}]", (Object)ldap.getLdapUrl());
                    constraints.setSearchScope(2);
                }
                constraints.setDerefLinkFlag(true);
                ldapDao.setSearchControls(constraints);
                ldapDao.setOrder(ldap.getOrder());
                LOGGER.debug("Initializing LDAP attribute source for [{}]", (Object)ldap.getLdapUrl());
                ldapDao.initialize();
                list.add((IPersonAttributeDao)ldapDao);
            }
        });
        return list;
    }

    @ConditionalOnMissingBean(name={"scriptedAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> scriptedAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        this.casProperties.getAuthn().getAttributeRepository().getScript().forEach(Unchecked.consumer(script -> {
            String scriptContents = IOUtils.toString((InputStream)script.getLocation().getInputStream(), (Charset)StandardCharsets.UTF_8);
            String engineName = script.getEngineName() == null ? ScriptEnginePersonAttributeDao.getScriptEngineName((String)script.getLocation().getFilename()) : script.getEngineName();
            ScriptEnginePersonAttributeDao dao = new ScriptEnginePersonAttributeDao(scriptContents, engineName);
            dao.setCaseInsensitiveUsername(script.isCaseInsensitive());
            dao.setOrder(script.getOrder());
            LOGGER.debug("Configured scripted attribute sources from [{}]", (Object)script.getLocation());
            list.add((IPersonAttributeDao)dao);
        }));
        return list;
    }

    @ConditionalOnMissingBean(name={"restfulAttributeRepositories"})
    @Bean
    @RefreshScope
    public List<IPersonAttributeDao> restfulAttributeRepositories() {
        ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
        this.casProperties.getAuthn().getAttributeRepository().getRest().forEach(rest -> {
            if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
                RestfulPersonAttributeDao dao = new RestfulPersonAttributeDao();
                dao.setCaseInsensitiveUsername(rest.isCaseInsensitive());
                dao.setOrder(rest.getOrder());
                dao.setUrl(rest.getUrl());
                dao.setMethod(HttpMethod.resolve((String)rest.getMethod()).name());
                if (StringUtils.isNotBlank((CharSequence)rest.getBasicAuthPassword()) && StringUtils.isNotBlank((CharSequence)rest.getBasicAuthUsername())) {
                    dao.setBasicAuthPassword(rest.getBasicAuthPassword());
                    dao.setBasicAuthUsername(rest.getBasicAuthUsername());
                    LOGGER.debug("Basic authentication credentials are located for REST endpoint [{}]", (Object)rest.getUrl());
                } else {
                    LOGGER.debug("Basic authentication credentials are not defined for REST endpoint [{}]", (Object)rest.getUrl());
                }
                LOGGER.debug("Configured REST attribute sources from [{}]", (Object)rest.getUrl());
                list.add((IPersonAttributeDao)dao);
            }
        });
        return list;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cachingAttributeRepository"})
    public IPersonAttributeDao cachingAttributeRepository() {
        CachingPersonAttributeDaoImpl impl = new CachingPersonAttributeDaoImpl();
        impl.setCacheNullResults(false);
        PrincipalAttributesProperties props = this.casProperties.getAuthn().getAttributeRepository();
        Cache graphs = Caffeine.newBuilder().maximumSize((long)props.getMaximumCacheSize()).expireAfterWrite((long)props.getExpirationTime(), TimeUnit.valueOf(props.getExpirationTimeUnit().toUpperCase())).build();
        impl.setUserInfoCache((Map)graphs.asMap());
        impl.setCachedPersonAttributesDao(this.aggregatingAttributeRepository());
        LOGGER.debug("Configured cache expiration policy for merging attribute sources to be [{}] minute(s)", (Object)props.getExpirationTime());
        return impl;
    }

    @Bean
    @ConditionalOnMissingBean(name={"aggregatingAttributeRepository"})
    public IPersonAttributeDao aggregatingAttributeRepository() {
        MergingPersonAttributeDaoImpl mergingDao = new MergingPersonAttributeDaoImpl();
        String merger = ((String)StringUtils.defaultIfBlank((CharSequence)this.casProperties.getAuthn().getAttributeRepository().getMerger(), (CharSequence)"replace")).trim();
        LOGGER.debug("Configured merging strategy for attribute sources is [{}]", (Object)merger);
        mergingDao.setMerger(this.getAttributeMerger(merger));
        List<IPersonAttributeDao> list = this.attributeRepositories();
        mergingDao.setPersonAttributeDaos(list);
        if (list.isEmpty()) {
            LOGGER.debug("No attribute repository sources are available/defined to merge together.");
        } else {
            LOGGER.debug("Configured attribute repository sources to merge together: [{}]", list);
        }
        return mergingDao;
    }

    private IAttributeMerger getAttributeMerger(String merger) {
        switch (merger.toLowerCase()) {
            case "merge": {
                return new MultivaluedAttributeMerger();
            }
            case "add": {
                return new NoncollidingAttributeAdder();
            }
        }
        return new ReplacingAttributeAdder();
    }
}

