/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class VerifySecurityQuestionsAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifySecurityQuestionsAction.class);
    private final PasswordManagementService passwordManagementService;

    protected Event doExecute(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String username = requestContext.getFlowScope().getString("username");
        Map questions = this.passwordManagementService.getSecurityQuestions(username);
        List canonicalQuestions = BasePasswordManagementService.canonicalizeSecurityQuestions((Map)questions);
        LOGGER.debug("Canonical security questions are [{}]", (Object)canonicalQuestions);
        AtomicInteger i = new AtomicInteger(0);
        long c = canonicalQuestions.stream().filter(q -> {
            String answer = request.getParameter("q" + i.getAndIncrement());
            String answerOnRecord = (String)questions.get(q);
            boolean result = this.passwordManagementService.isValidSecurityQuestionAnswer(username, q, answerOnRecord, answer);
            LOGGER.trace("Validating security question [{}] with answer [{}] against provided answer [{}] by username [{}]: [{}]", new Object[]{q, answerOnRecord, answer, username, result});
            return result;
        }).count();
        if (c == (long)questions.size()) {
            return this.success();
        }
        LOGGER.error("Unable to validate answers to all security questions; only validated [{}] question(s) successfully", (Object)c);
        return this.error();
    }

    @Generated
    public VerifySecurityQuestionsAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }
}

