/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.AutoConfigurationReportEndpoint;
import org.springframework.boot.actuate.endpoint.BeansEndpoint;
import org.springframework.boot.actuate.endpoint.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.endpoint.DumpEndpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.InfoEndpoint;
import org.springframework.boot.actuate.endpoint.RequestMappingEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.TraceEndpoint;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public class DashboardController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardController.class);
    @Autowired(required=false)
    private RestartEndpoint restartEndpoint;
    @Autowired(required=false)
    private ShutdownEndpoint shutdownEndpoint;
    @Autowired
    private InfoEndpoint infoEndpoint;
    @Autowired
    private AutoConfigurationReportEndpoint autoConfigurationReportEndpoint;
    @Autowired
    private BeansEndpoint beansEndpoint;
    @Autowired
    private DumpEndpoint dumpEndpoint;
    @Autowired
    private ConfigurationPropertiesReportEndpoint configPropertiesEndpoint;
    @Autowired
    private RequestMappingEndpoint requestMappingEndpoint;
    @Autowired
    private HealthEndpoint healthEndpoint;
    @Autowired
    private TraceEndpoint traceEndpoint;
    @Autowired
    private EnvironmentEndpoint environmentEndpoint;

    public DashboardController(CasConfigurationProperties casProperties) {
        super("casdashboard", "/dashboard", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getDashboard(), casProperties);
    }

    @GetMapping
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        Map<String, Object> model = this.getEndpointsModelMap();
        return new ModelAndView("monitoring/viewDashboard", model);
    }

    @GetMapping(value={"/endpoints"})
    @ResponseBody
    public Set<EndpointBean> getEndpoints(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        Map<String, Object> endpointsModel = this.getEndpointsModelMap();
        return endpointsModel.entrySet().stream().map(entry -> {
            EndpointBean bean = new EndpointBean();
            bean.setName(StringUtils.remove((String)((String)entry.getKey()), (String)"Enabled"));
            String title = StringUtils.capitalize((String)StringUtils.remove((String)bean.getName(), (String)"Endpoint"));
            title = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)title), (char)' ');
            bean.setTitle(title);
            return bean;
        }).collect(Collectors.toSet());
    }

    private Map<String, Object> getEndpointsModelMap() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.processSpringBootEndpoints(model);
        this.processCasProvidedEndpoints(model);
        boolean endpointAvailable = model.entrySet().stream().anyMatch(e -> ((String)e.getKey()).endsWith("Enabled") && BooleanUtils.toBoolean((String)e.getValue().toString()));
        model.put("dashboardEndpointsEnabled", endpointAvailable);
        model.put("actuatorEndpointsEnabled", this.casProperties.getAdminPagesSecurity().isActuatorEndpointsEnabled());
        return model;
    }

    private void processCasProvidedEndpoints(Map<String, Object> model) {
        MonitorProperties.Endpoints endpoints = this.casProperties.getMonitor().getEndpoints();
        model.put("trustedDevicesEnabled", this.applicationContext.containsBean("trustedDevicesController") && DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getTrustedDevices(), (CasConfigurationProperties)this.casProperties));
        model.put("authenticationEventsRepositoryEnabled", this.applicationContext.containsBean("casEventRepository") && DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getAuthenticationEvents(), (CasConfigurationProperties)this.casProperties));
        model.put("singleSignOnReportEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getSingleSignOnReport(), (CasConfigurationProperties)this.casProperties));
        model.put("statisticsEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getStatistics(), (CasConfigurationProperties)this.casProperties));
        model.put("singleSignOnStatusEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getSingleSignOnStatus(), (CasConfigurationProperties)this.casProperties));
        model.put("springWebflowEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getSpringWebflowReport(), (CasConfigurationProperties)this.casProperties));
        model.put("auditLogEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getAuditEvents(), (CasConfigurationProperties)this.casProperties));
        model.put("configurationStateEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getConfigurationState(), (CasConfigurationProperties)this.casProperties));
        model.put("healthCheckEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getHealthCheck(), (CasConfigurationProperties)this.casProperties));
        model.put("metricsEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getMetrics(), (CasConfigurationProperties)this.casProperties));
        model.put("servicesEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getRegisteredServicesReport(), (CasConfigurationProperties)this.casProperties));
        model.put("discoveryProfileEndpointEnabled", this.applicationContext.containsBean("casServerProfileRegistrar") && DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getDiscovery(), (CasConfigurationProperties)this.casProperties));
        model.put("attributeResolutionEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getAttributeResolution(), (CasConfigurationProperties)this.casProperties));
        model.put("configurationMetadataEndpointEnabled", DashboardController.isEndpointCapable((MonitorProperties.BaseEndpoint)endpoints.getConfigurationMetadata(), (CasConfigurationProperties)this.casProperties));
    }

    private void processSpringBootEndpoints(Map<String, Object> model) {
        model.put("restartEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.restartEndpoint));
        model.put("shutdownEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.shutdownEndpoint));
        model.put("environmentEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.environmentEndpoint));
        model.put("serverFunctionsEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.restartEndpoint) || this.isSpringBootEndpointEnabled((AbstractEndpoint)this.shutdownEndpoint));
        model.put("autoConfigurationEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.autoConfigurationReportEndpoint));
        model.put("beansEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.beansEndpoint));
        model.put("mappingsEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.requestMappingEndpoint));
        model.put("configPropsEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.configPropertiesEndpoint));
        model.put("dumpEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.dumpEndpoint));
        model.put("infoEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.infoEndpoint));
        model.put("healthEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.healthEndpoint));
        model.put("traceEndpointEnabled", this.isSpringBootEndpointEnabled((AbstractEndpoint)this.traceEndpoint));
    }

    private boolean isSpringBootEndpointEnabled(AbstractEndpoint endpoint) {
        return endpoint != null && endpoint.isEnabled();
    }

    @Generated
    public RestartEndpoint getRestartEndpoint() {
        return this.restartEndpoint;
    }

    @Generated
    public ShutdownEndpoint getShutdownEndpoint() {
        return this.shutdownEndpoint;
    }

    @Generated
    public InfoEndpoint getInfoEndpoint() {
        return this.infoEndpoint;
    }

    @Generated
    public AutoConfigurationReportEndpoint getAutoConfigurationReportEndpoint() {
        return this.autoConfigurationReportEndpoint;
    }

    @Generated
    public BeansEndpoint getBeansEndpoint() {
        return this.beansEndpoint;
    }

    @Generated
    public DumpEndpoint getDumpEndpoint() {
        return this.dumpEndpoint;
    }

    @Generated
    public ConfigurationPropertiesReportEndpoint getConfigPropertiesEndpoint() {
        return this.configPropertiesEndpoint;
    }

    @Generated
    public RequestMappingEndpoint getRequestMappingEndpoint() {
        return this.requestMappingEndpoint;
    }

    @Generated
    public HealthEndpoint getHealthEndpoint() {
        return this.healthEndpoint;
    }

    @Generated
    public TraceEndpoint getTraceEndpoint() {
        return this.traceEndpoint;
    }

    @Generated
    public EnvironmentEndpoint getEnvironmentEndpoint() {
        return this.environmentEndpoint;
    }

    public static class EndpointBean
    implements Serializable {
        private static final long serialVersionUID = -3446962071459197099L;
        private String name;
        private String title;

        @Generated
        public EndpointBean() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndpointBean)) {
                return false;
            }
            EndpointBean other = (EndpointBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.title;
            String other$title = other.title;
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EndpointBean;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.title;
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DashboardController.EndpointBean(name=" + this.name + ", title=" + this.title + ")";
        }
    }
}

