/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apereo.cas.web.report.util.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class LoggingOutputTailingService
extends TailerListenerAdapter
implements AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingOutputTailingService.class);
    private static final String LOG_OUTPUT_STOMP_DESTINATION = "/topic/logs";
    private final TaskExecutor taskExecutor;
    private final SimpMessagingTemplate stompMessagingTemplate;
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final List<Tailer> tailers = new ArrayList<Tailer>();

    @PostConstruct
    public void initialize() {
        Optional<Pair<Resource, LoggerContext>> pair = ControllerUtils.buildLoggerContext(this.environment, this.resourceLoader);
        pair.ifPresent(it -> this.registerLogFileTailersForExecution((LoggerContext)it.getValue()));
    }

    @PreDestroy
    public void cleanUp() {
        this.tailers.forEach(Tailer::stop);
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    private void registerLogFileTailersForExecution(LoggerContext loggerContext) {
        HashSet outputFileNames = new HashSet();
        Collection loggerAppenders = loggerContext.getConfiguration().getAppenders().values();
        loggerAppenders.forEach(appender -> {
            if (appender instanceof FileAppender) {
                outputFileNames.add(((FileAppender)FileAppender.class.cast(appender)).getFileName());
            } else if (appender instanceof RandomAccessFileAppender) {
                outputFileNames.add(((RandomAccessFileAppender)RandomAccessFileAppender.class.cast(appender)).getFileName());
            } else if (appender instanceof RollingFileAppender) {
                outputFileNames.add(((RollingFileAppender)RollingFileAppender.class.cast(appender)).getFileName());
            } else if (appender instanceof MemoryMappedFileAppender) {
                outputFileNames.add(((MemoryMappedFileAppender)MemoryMappedFileAppender.class.cast(appender)).getFileName());
            } else if (appender instanceof RollingRandomAccessFileAppender) {
                outputFileNames.add(((RollingRandomAccessFileAppender)RollingRandomAccessFileAppender.class.cast(appender)).getFileName());
            }
        });
        outputFileNames.forEach(f -> {
            Tailer t = new Tailer(new File((String)f), (TailerListener)this, 100L, false, true);
            this.tailers.add(t);
            this.taskExecutor.execute((Runnable)t);
        });
    }

    public void handle(String line) {
        this.stompMessagingTemplate.convertAndSend((Object)LOG_OUTPUT_STOMP_DESTINATION, (Object)line);
    }

    public void handle(Exception ex) {
        this.handle(ex.getMessage());
    }

    @Generated
    public LoggingOutputTailingService(TaskExecutor taskExecutor, SimpMessagingTemplate stompMessagingTemplate, Environment environment, ResourceLoader resourceLoader) {
        this.taskExecutor = taskExecutor;
        this.stompMessagingTemplate = stompMessagingTemplate;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
    }
}

