/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.BasicIdentifiableCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.io.CopyPrintWriter;
import org.apereo.cas.util.io.CopyServletOutputStream;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class PersonDirectoryAttributeResolutionController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonDirectoryAttributeResolutionController.class);
    private final ServicesManager servicesManager;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final PrincipalResolver personDirectoryPrincipalResolver;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final PrincipalFactory principalFactory;
    private final View cas3ServiceSuccessView;
    private final View cas3ServiceJsonView;
    private final View cas2ServiceSuccessView;
    private final View cas1ServiceSuccessView;

    public PersonDirectoryAttributeResolutionController(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationSystemSupport authenticationSystemSupport, PrincipalResolver personDirectoryPrincipalResolver, ServiceFactory<WebApplicationService> serviceFactory, PrincipalFactory principalFactory, View cas3ServiceSuccessView, View cas3ServiceJsonView, View cas2ServiceSuccessView, View cas1ServiceSuccessView) {
        super("attrresolution", "/attrresolution", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getAttributeResolution(), casProperties);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.personDirectoryPrincipalResolver = personDirectoryPrincipalResolver;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.cas3ServiceSuccessView = cas3ServiceSuccessView;
        this.cas3ServiceJsonView = cas3ServiceJsonView;
        this.cas2ServiceSuccessView = cas2ServiceSuccessView;
        this.cas1ServiceSuccessView = cas1ServiceSuccessView;
    }

    @GetMapping
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        LinkedHashMap model = new LinkedHashMap();
        return new ModelAndView("monitoring/attrresolution", model);
    }

    @PostMapping(value={"/resolveattrs"})
    @ResponseBody
    public Map<String, Object> resolvePrincipalAttributes(@RequestParam String uid, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        Principal p = this.personDirectoryPrincipalResolver.resolve((Credential)new BasicIdentifiableCredential(uid));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("uid", p.getId());
        map.put("attributes", p.getAttributes());
        return map;
    }

    @PostMapping(value={"/releaseattrs"})
    @ResponseBody
    public Map<String, Object> releasePrincipalAttributes(@RequestParam String username, @RequestParam String password, @RequestParam String service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> resValidation = new HashMap<String, Object>();
        Service selectedService = this.serviceFactory.createService(service);
        RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        AuthenticationResult result = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(selectedService, new Credential[]{credential});
        Authentication authentication = result.getAuthentication();
        Principal principal = authentication.getPrincipal();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(principal, selectedService, registeredService);
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, selectedService, registeredService);
        Principal modifiedPrincipal = this.principalFactory.createPrincipal(principalId, attributesToRelease);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance((Authentication)authentication);
        builder.setPrincipal(modifiedPrincipal);
        Authentication finalAuthentication = builder.build();
        Assertion assertion = new DefaultAssertionBuilder(finalAuthentication).with(selectedService).with(CollectionUtils.wrap((Object)finalAuthentication)).build();
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put("assertion", assertion);
        model.put("service", selectedService);
        resValidation.put("registeredService", registeredService);
        String copy = ((CopyPrintWriter)this.renderViewAndGetResult(this.cas1ServiceSuccessView, model, request, response).getKey()).getCopy();
        resValidation.put("cas1Response", StringEscapeUtils.escapeXml11((String)copy));
        copy = this.casProperties.getView().getCas2().isV3ForwardCompatible() ? ((CopyPrintWriter)this.renderViewAndGetResult(this.cas3ServiceSuccessView, model, request, response).getKey()).getCopy() : ((CopyPrintWriter)this.renderViewAndGetResult(this.cas2ServiceSuccessView, model, request, response).getKey()).getCopy();
        resValidation.put("cas2Response", StringEscapeUtils.escapeXml11((String)copy));
        copy = ((CopyPrintWriter)this.renderViewAndGetResult(this.cas3ServiceSuccessView, model, request, response).getKey()).getCopy();
        resValidation.put("cas3XmlResponse", StringEscapeUtils.escapeXml11((String)copy));
        copy = ((CopyServletOutputStream)this.renderViewAndGetResult(this.cas3ServiceJsonView, model, request, response).getValue()).getStringCopy();
        resValidation.put("cas3JsonResponse", copy);
        response.reset();
        return resValidation;
    }

    private Pair<CopyPrintWriter, CopyServletOutputStream> renderViewAndGetResult(View view, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        final CopyPrintWriter writer = new CopyPrintWriter();
        final CopyServletOutputStream stream = new CopyServletOutputStream((OutputStream)response.getOutputStream());
        HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper(response){

            public PrintWriter getWriter() {
                return writer;
            }

            public ServletOutputStream getOutputStream() {
                return stream;
            }
        };
        view.render(model, request, (HttpServletResponse)wrapper);
        return Pair.of((Object)writer, (Object)stream);
    }
}

