/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.apereo.inspektr.audit.AuditActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.servlet.ModelAndView;

public class StatisticsController
extends BaseCasMvcEndpoint
implements ServletContextAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsController.class);
    private static final int NUMBER_OF_BYTES_IN_A_KILOBYTE = 1024;
    private static final String MONITORING_VIEW_STATISTICS = "monitoring/viewStatistics";
    private final ZonedDateTime upTimeStartDate = ZonedDateTime.now(ZoneOffset.UTC);
    private final AuditTrailExecutionPlan auditTrailManager;
    private final CentralAuthenticationService centralAuthenticationService;
    private final MetricRegistry metricsRegistry;
    private final HealthCheckRegistry healthCheckRegistry;

    public StatisticsController(AuditTrailExecutionPlan auditTrailManager, CentralAuthenticationService centralAuthenticationService, MetricRegistry metricsRegistry, HealthCheckRegistry healthCheckRegistry, CasConfigurationProperties casProperties) {
        super("casstats", "/stats", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getStatistics(), casProperties);
        this.auditTrailManager = auditTrailManager;
        this.centralAuthenticationService = centralAuthenticationService;
        this.metricsRegistry = metricsRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    @GetMapping(value={"/getAvailability"})
    @ResponseBody
    public Map<String, Object> getAvailability(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> model = new HashMap<String, Object>();
        Duration diff = Duration.between(this.upTimeStartDate, ZonedDateTime.now(ZoneOffset.UTC));
        model.put("upTime", diff.getSeconds());
        return model;
    }

    @GetMapping(value={"/getMemStats"})
    @ResponseBody
    public Map<String, Object> getMemoryStats(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> model = new HashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        model.put("totalMemory", StatisticsController.convertToMegaBytes(runtime.totalMemory()));
        model.put("maxMemory", StatisticsController.convertToMegaBytes(runtime.maxMemory()));
        model.put("freeMemory", StatisticsController.convertToMegaBytes(runtime.freeMemory()));
        return model;
    }

    @GetMapping(value={"/getAuthnAudit"})
    @ResponseBody
    public Set<AuditActionContext> getAuthnAudit(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        LocalDate sinceDate = LocalDate.now().minusDays(this.casProperties.getAudit().getNumberOfDaysInHistory());
        return this.auditTrailManager.getAuditRecordsSince(sinceDate);
    }

    @GetMapping(value={"/getAuthnAudit/summary"})
    @ResponseBody
    public WebAsyncTask<Collection<AuthenticationAuditSummary>> getAuthnAuditSummary(HttpServletRequest request, HttpServletResponse response, @RequestParam long start, @RequestParam String range, @RequestParam String scale) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        response.setContentType("application/json");
        Callable<Collection> asyncTask = () -> {
            Set<AuditActionContext> audits = this.getAuthnAudit(request, response);
            LocalDateTime startDate = DateTimeUtils.localDateTimeOf((long)start);
            LocalDateTime endDate = startDate.plus(Duration.parse(range));
            List authnEvents = audits.stream().filter(a -> {
                LocalDateTime actionTime = DateTimeUtils.localDateTimeOf((Date)a.getWhenActionWasPerformed());
                return !(!actionTime.isEqual(startDate) && !actionTime.isAfter(startDate) || !actionTime.isEqual(endDate) && !actionTime.isBefore(endDate) || !a.getActionPerformed().matches("AUTHENTICATION_(SUCCESS|FAILED)"));
            }).sorted(Comparator.comparing(AuditActionContext::getWhenActionWasPerformed)).collect(Collectors.toList());
            Duration steps = Duration.parse(scale);
            LinkedHashMap buckets = Maps.newLinkedHashMapWithExpectedSize((int)authnEvents.size());
            LocalDateTime dt = startDate;
            Integer index = 0;
            while (dt != null) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                buckets.put(n, dt);
                if (!(dt = dt.plus(steps)).isAfter(endDate)) continue;
                dt = null;
            }
            LinkedHashMap<LocalDateTime, AuthenticationAuditSummary> summary = new LinkedHashMap<LocalDateTime, AuthenticationAuditSummary>();
            boolean foundBucket = false;
            block1: for (AuditActionContext event : authnEvents) {
                foundBucket = false;
                for (int i = 0; i < buckets.keySet().size(); ++i) {
                    LocalDateTime bucketDateTime;
                    LocalDateTime actionTime = DateTimeUtils.localDateTimeOf((Date)event.getWhenActionWasPerformed());
                    if (!actionTime.isEqual(bucketDateTime = (LocalDateTime)buckets.get(i)) && !actionTime.isAfter(bucketDateTime)) continue;
                    for (int j = 0; j < buckets.keySet().size(); ++j) {
                        AuthenticationAuditSummary values;
                        LocalDateTime nextBucketDateTime = (LocalDateTime)buckets.get(j);
                        if (!actionTime.isBefore(nextBucketDateTime)) continue;
                        LocalDateTime bucketToUse = (LocalDateTime)buckets.get(j - 1);
                        if (summary.containsKey(bucketToUse)) {
                            values = (AuthenticationAuditSummary)summary.get(bucketToUse);
                        } else {
                            long l = bucketToUse.toInstant(ZoneOffset.UTC).toEpochMilli();
                            values = new AuthenticationAuditSummary(l);
                        }
                        if (event.getActionPerformed().contains("SUCCESS")) {
                            values.incrementSuccess();
                        } else {
                            values.incrementFailure();
                        }
                        summary.put(bucketToUse, values);
                        foundBucket = true;
                        break;
                    }
                    if (foundBucket) continue block1;
                }
            }
            Collection values = summary.values();
            return values;
        };
        long timeout = Beans.newDuration((String)this.casProperties.getHttpClient().getAsyncTimeout()).toMillis();
        return new WebAsyncTask(timeout, asyncTask);
    }

    @GetMapping(value={"/getTicketStats"})
    @ResponseBody
    public Map<String, Object> getTicketStats(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> model = new HashMap<String, Object>();
        int unexpiredTgts = 0;
        int unexpiredSts = 0;
        int expiredTgts = 0;
        int expiredSts = 0;
        Collection tickets = this.centralAuthenticationService.getTickets(ticket -> true);
        for (Ticket ticket2 : tickets) {
            if (ticket2 instanceof ServiceTicket) {
                if (ticket2.isExpired()) {
                    this.centralAuthenticationService.deleteTicket(ticket2.getId());
                    ++expiredSts;
                    continue;
                }
                ++unexpiredSts;
                continue;
            }
            if (ticket2.isExpired()) {
                this.centralAuthenticationService.deleteTicket(ticket2.getId());
                ++expiredTgts;
                continue;
            }
            ++unexpiredTgts;
        }
        model.put("unexpiredTgts", unexpiredTgts);
        model.put("unexpiredSts", unexpiredSts);
        model.put("expiredTgts", expiredTgts);
        model.put("expiredSts", expiredSts);
        return model;
    }

    @GetMapping
    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.ensureEndpointAccessIsAuthorized(httpServletRequest, httpServletResponse);
        ModelAndView modelAndView = new ModelAndView(MONITORING_VIEW_STATISTICS);
        modelAndView.addObject("pageTitle", (Object)modelAndView.getViewName());
        modelAndView.addObject("availableProcessors", (Object)Runtime.getRuntime().availableProcessors());
        modelAndView.addObject("casTicketSuffix", (Object)this.casProperties.getHost().getName());
        modelAndView.getModel().putAll(this.getAvailability(httpServletRequest, httpServletResponse));
        modelAndView.addObject("startTime", (Object)this.upTimeStartDate.toLocalDateTime());
        modelAndView.getModel().putAll(this.getMemoryStats(httpServletRequest, httpServletResponse));
        return modelAndView;
    }

    private static double convertToMegaBytes(double bytes) {
        return bytes / 1024.0 / 1024.0;
    }

    public void setServletContext(ServletContext servletContext) {
        servletContext.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)this.metricsRegistry);
        servletContext.setAttribute(MetricsServlet.SHOW_SAMPLES, (Object)Boolean.TRUE);
        servletContext.setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)this.healthCheckRegistry);
    }

    private static class AuthenticationAuditSummary {
        private final long time;
        private long successes;
        private long failures;

        AuthenticationAuditSummary(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }

        public long getSuccesses() {
            return this.successes;
        }

        public long getFailures() {
            return this.failures;
        }

        public void incrementSuccess() {
            ++this.successes;
        }

        public void incrementFailure() {
            ++this.failures;
        }
    }
}

