/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.LdapReferralException;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.ExtendedResponseFactory;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderUtils;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.JndiUtils;
import org.ldaptive.provider.jndi.NamingExceptionUtils;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.SaslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiConnection
implements ProviderConnection {
    public static final String AUTHENTICATION = "java.naming.security.authentication";
    public static final String CREDENTIALS = "java.naming.security.credentials";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String SASL_AUTHZ_ID = "java.naming.security.sasl.authorizationId";
    public static final String SASL_QOP = "javax.security.sasl.qop";
    public static final String SASL_STRENGTH = "javax.security.sasl.strength";
    public static final String SASL_MUTUAL_AUTH = "javax.security.sasl.server.authentication";
    public static final String SASL_REALM = "java.naming.security.sasl.realm";
    public static final String DELETE_RDN = "java.naming.ldap.deleteRDN";
    public static final String BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    public static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    public static final String REFERRAL = "java.naming.referral";
    public static final String TYPES_ONLY = "java.naming.ldap.typesOnly";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LdapContext context;
    private final JndiProviderConfig config;

    public JndiConnection(LdapContext lc, JndiProviderConfig pc) {
        this.context = lc;
        this.config = pc;
    }

    public LdapContext getLdapContext() {
        return this.context;
    }

    @Override
    public void close(RequestControl[] controls) throws LdapException {
        if (controls != null) {
            throw new UnsupportedOperationException("Provider does not support unbind with controls");
        }
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException e) {
            ResultCode rc = NamingExceptionUtils.getResultCode(e.getClass());
            if (rc == null) {
                rc = NamingExceptionUtils.getResultCode(e.getMessage());
            }
            throw new LdapException(e, rc);
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public Response<Void> bind(BindRequest request) throws LdapException {
        Response<Void> response = request.getSaslConfig() != null ? this.saslBind(request) : (request.getDn() == null && request.getCredential() == null ? this.anonymousBind(request) : this.simpleBind(request));
        return response;
    }

    protected Response<Void> anonymousBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            this.context.addToEnvironment(AUTHENTICATION, "none");
            this.context.removeFromEnvironment(PRINCIPAL);
            this.context.removeFromEnvironment(CREDENTIALS);
            this.context.reconnect((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            response = this.createResponse(request, null, ResultCode.SUCCESS, null, this.context);
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, this.context);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, this.context);
        }
        return response;
    }

    protected Response<Void> simpleBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            this.context.addToEnvironment(AUTHENTICATION, "simple");
            this.context.addToEnvironment(PRINCIPAL, request.getDn());
            this.context.addToEnvironment(CREDENTIALS, request.getCredential().getBytes());
            this.context.reconnect((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            response = this.createResponse(request, null, ResultCode.SUCCESS, null, this.context);
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, this.context);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, this.context);
        }
        return response;
    }

    protected Response<Void> saslBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            String authenticationType = JndiUtils.getAuthenticationType(request.getSaslConfig().getMechanism());
            for (Map.Entry<String, Object> entry : JndiConnection.getSaslProperties(request.getSaslConfig()).entrySet()) {
                this.context.addToEnvironment(entry.getKey(), entry.getValue());
            }
            this.context.addToEnvironment(AUTHENTICATION, authenticationType);
            if (request.getDn() != null) {
                this.context.addToEnvironment(PRINCIPAL, request.getDn());
                if (request.getCredential() != null) {
                    this.context.addToEnvironment(CREDENTIALS, request.getCredential().getBytes());
                }
            }
            this.context.reconnect((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            response = this.createResponse(request, null, ResultCode.SUCCESS, null, this.context);
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, this.context);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, this.context);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> add(AddRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            try {
                ctx = this.initializeContext(request);
                JndiUtils bu = new JndiUtils();
                ctx.createSubcontext(new LdapName(request.getDn()), bu.fromLdapAttributes(request.getLdapAttributes())).close();
                response = this.createResponse(request, null, ResultCode.SUCCESS, null, ctx);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Boolean> compare(CompareRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            NamingEnumeration<SearchResult> en = null;
            try {
                Object[] objectArray;
                ctx = this.initializeContext(request);
                LdapName ldapName = new LdapName(request.getDn());
                String string = String.format("(%s={0})", request.getAttribute().getName());
                if (request.getAttribute().isBinary()) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = request.getAttribute().getBinaryValue();
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = request.getAttribute().getStringValue();
                }
                en = ctx.search(ldapName, string, objectArray, JndiConnection.getCompareSearchControls());
                boolean success = en.hasMore();
                response = this.createResponse(request, success, success ? ResultCode.COMPARE_TRUE : ResultCode.COMPARE_FALSE, null, ctx);
            }
            finally {
                if (en != null) {
                    en.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> delete(DeleteRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            try {
                ctx = this.initializeContext(request);
                ctx.destroySubcontext(new LdapName(request.getDn()));
                response = this.createResponse(request, null, ResultCode.SUCCESS, null, ctx);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> modify(ModifyRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            try {
                ctx = this.initializeContext(request);
                JndiUtils bu = new JndiUtils();
                ctx.modifyAttributes(new LdapName(request.getDn()), bu.fromAttributeModification(request.getAttributeModifications()));
                response = this.createResponse(request, null, ResultCode.SUCCESS, null, ctx);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            try {
                ctx = this.initializeContext(request);
                ctx.addToEnvironment(DELETE_RDN, Boolean.valueOf(request.getDeleteOldRDn()).toString());
                ctx.rename(new LdapName(request.getDn()), new LdapName(request.getNewDn()));
                response = this.createResponse(request, null, ResultCode.SUCCESS, null, ctx);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    @Override
    public SearchIterator search(SearchRequest request) throws LdapException {
        JndiSearchIterator i = new JndiSearchIterator(request);
        i.initialize();
        return i;
    }

    @Override
    public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
        throw new UnsupportedOperationException("Asynchronous searches not supported");
    }

    @Override
    public void abandon(int messageId, RequestControl[] controls) throws LdapException {
        throw new UnsupportedOperationException("Abandons not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<?> extendedOperation(ExtendedRequest request) throws LdapException {
        Response<Object> response = null;
        LdapContext ctx = null;
        try {
            try {
                ctx = this.initializeContext(request);
                JndiExtendedResponse jndiExtRes = (JndiExtendedResponse)ctx.extendedOperation(new JndiExtendedRequest(request.getOID(), request.encode()));
                ExtendedResponse<?> extRes = ExtendedResponseFactory.createExtendedResponse(request.getOID(), jndiExtRes.getID(), jndiExtRes.getEncodedValue());
                response = this.createResponse(request, extRes.getValue(), ResultCode.SUCCESS, null, ctx);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
        catch (ReferralException e) {
            String[] stringArray;
            if (e.getReferralInfo() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)e.getReferralInfo();
            } else {
                stringArray = null;
            }
            String[] refUrls = stringArray;
            response = this.createResponse(request, null, ResultCode.REFERRAL, refUrls, ctx);
        }
        catch (NamingException e) {
            this.processNamingException(request, e, null, ctx);
        }
        return response;
    }

    @Override
    public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    @Override
    public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    public static SearchControls getCompareSearchControls() {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(SearchScope.OBJECT.ordinal());
        return ctls;
    }

    protected LdapContext initializeContext(Request request) throws NamingException {
        LdapContext ctx = this.context.newInstance((Control[])this.config.getControlProcessor().processRequestControls((RequestControl[])request.getControls()));
        ctx.addToEnvironment(REFERRAL, "throw");
        return ctx;
    }

    protected <T> Response<T> createResponse(Request request, T result, ResultCode code, String[] urls, LdapContext ctx) {
        return new Response<T>(result, code, null, null, this.processResponseControls(this.config.getControlProcessor(), (RequestControl[])request.getControls(), ctx), urls, -1);
    }

    protected void processNamingException(Request request, NamingException e, String[] urls, LdapContext ctx) throws LdapException {
        ResultCode rc = NamingExceptionUtils.getResultCode(e.getClass());
        if (rc == null) {
            rc = NamingExceptionUtils.getResultCode(e.getMessage());
        }
        ProviderUtils.throwOperationException(this.config.getOperationExceptionResultCodes(), e, rc != null ? rc.value() : -1, null, this.processResponseControls(this.config.getControlProcessor(), (RequestControl[])request.getControls(), ctx), urls, true);
    }

    protected ResponseControl[] processResponseControls(ControlProcessor<Control> processor, RequestControl[] requestControls, LdapContext ctx) {
        ResponseControl[] ctls = null;
        if (ctx != null) {
            try {
                ctls = processor.processResponseControls((Control[])ctx.getResponseControls());
            }
            catch (NamingException e) {
                Logger l = LoggerFactory.getLogger(JndiUtils.class);
                l.warn("Error retrieving response controls.", (Throwable)e);
            }
        }
        return ctls;
    }

    protected static Map<String, Object> getSaslProperties(SaslConfig config) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (config.getAuthorizationId() != null && !"".equals(config.getAuthorizationId())) {
            env.put(SASL_AUTHZ_ID, config.getAuthorizationId());
        }
        if (config.getQualityOfProtection() != null) {
            env.put(SASL_QOP, JndiUtils.getQualityOfProtection(config.getQualityOfProtection()));
        }
        if (config.getSecurityStrength() != null) {
            env.put(SASL_STRENGTH, JndiUtils.getSecurityStrength(config.getSecurityStrength()));
        }
        if (config.getMutualAuthentication() != null) {
            env.put(SASL_MUTUAL_AUTH, config.getMutualAuthentication().toString());
        }
        if (config instanceof DigestMd5Config && ((DigestMd5Config)config).getRealm() != null) {
            env.put(SASL_REALM, ((DigestMd5Config)config).getRealm());
        }
        return env;
    }

    protected static class JndiExtendedResponse
    implements javax.naming.ldap.ExtendedResponse {
        private final String oid;
        private final byte[] encoded;

        public JndiExtendedResponse(String id, byte[] berValue) {
            this.oid = id;
            this.encoded = berValue;
        }

        @Override
        public String getID() {
            return this.oid;
        }

        @Override
        public byte[] getEncodedValue() {
            return this.encoded;
        }
    }

    protected static class JndiExtendedRequest
    implements javax.naming.ldap.ExtendedRequest {
        private final String oid;
        private final byte[] encoded;

        public JndiExtendedRequest(String id, byte[] berValue) {
            this.oid = id;
            this.encoded = berValue;
        }

        @Override
        public String getID() {
            return this.oid;
        }

        @Override
        public byte[] getEncodedValue() {
            return this.encoded;
        }

        @Override
        public javax.naming.ldap.ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
            byte[] b = null;
            if (berValue != null) {
                b = new byte[length];
                System.arraycopy(berValue, offset, b, 0, length);
            }
            return new JndiExtendedResponse(id, b);
        }
    }

    protected class JndiSearchIterator
    implements SearchIterator {
        private final SearchRequest request;
        private Response<Void> response;
        private ResultCode responseResultCode;
        private List<String> searchReferences;
        private LdapContext searchContext;
        private NamingEnumeration<SearchResult> results;

        public JndiSearchIterator(SearchRequest sr) {
            this.request = sr;
        }

        public void initialize() throws LdapException {
            boolean closeContext = false;
            try {
                this.searchContext = JndiConnection.this.context.newInstance((Control[])JndiConnection.this.config.getControlProcessor().processRequestControls(this.request.getControls()));
                this.initializeSearchContext(this.searchContext, this.request);
                this.results = this.search(this.searchContext, this.request);
            }
            catch (LdapReferralException e) {
                closeContext = true;
                this.response = JndiConnection.this.createResponse(this.request, null, ResultCode.REFERRAL, this.readReferralUrls(e), this.searchContext);
            }
            catch (NamingException e) {
                closeContext = true;
                JndiConnection.this.processNamingException(this.request, e, null, this.searchContext);
            }
            finally {
                if (closeContext) {
                    try {
                        if (this.searchContext != null) {
                            this.searchContext.close();
                        }
                    }
                    catch (NamingException e) {
                        JndiConnection.this.logger.debug("Problem closing context", (Throwable)e);
                    }
                }
            }
        }

        protected void initializeSearchContext(LdapContext ctx, SearchRequest sr) throws NamingException {
            ctx.addToEnvironment(JndiConnection.REFERRAL, "throw");
            if (sr.getDerefAliases() != null) {
                ctx.addToEnvironment(JndiConnection.DEREF_ALIASES, sr.getDerefAliases().name().toLowerCase());
            } else {
                ctx.addToEnvironment(JndiConnection.DEREF_ALIASES, DerefAliases.NEVER.name().toLowerCase());
            }
            if (sr.getBinaryAttributes() != null) {
                String[] a = sr.getBinaryAttributes();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < a.length; ++i) {
                    sb.append(a[i]);
                    if (i >= a.length - 1) continue;
                    sb.append(" ");
                }
                ctx.addToEnvironment(JndiConnection.BINARY_ATTRIBUTES, sb.toString());
            }
            if (sr.getTypesOnly()) {
                ctx.addToEnvironment(JndiConnection.TYPES_ONLY, Boolean.valueOf(sr.getTypesOnly()).toString());
            }
        }

        protected NamingEnumeration<SearchResult> search(LdapContext ctx, SearchRequest sr) throws NamingException {
            return ctx.search((Name)new LdapName(sr.getBaseDn()), sr.getSearchFilter() != null ? this.request.getSearchFilter().format() : null, this.getSearchControls(sr));
        }

        protected SearchControls getSearchControls(SearchRequest sr) {
            SearchControls ctls = new SearchControls();
            if (ReturnAttributes.DEFAULT.equalsAttributes(sr.getReturnAttributes())) {
                ctls.setReturningAttributes(null);
            } else {
                ctls.setReturningAttributes(sr.getReturnAttributes());
            }
            int searchScope = this.getSearchScope(sr.getSearchScope());
            if (searchScope != -1) {
                ctls.setSearchScope(searchScope);
            }
            ctls.setTimeLimit((int)sr.getTimeLimit().toMillis());
            ctls.setCountLimit(sr.getSizeLimit());
            ctls.setDerefLinkFlag(false);
            ctls.setReturningObjFlag(false);
            return ctls;
        }

        protected int getSearchScope(SearchScope ss) {
            int scope = -1;
            if (ss == SearchScope.OBJECT) {
                scope = 0;
            } else if (ss == SearchScope.ONELEVEL) {
                scope = 1;
            } else if (ss == SearchScope.SUBTREE) {
                scope = 2;
            }
            return scope;
        }

        @Override
        public boolean hasNext() throws LdapException {
            if (this.results == null || this.response != null) {
                return false;
            }
            boolean more = false;
            if (this.searchReferences != null) {
                more = true;
            } else {
                try {
                    more = this.results.hasMore();
                    if (!more) {
                        this.response = JndiConnection.this.createResponse(this.request, null, this.responseResultCode != null ? this.responseResultCode : ResultCode.SUCCESS, null, this.searchContext);
                    }
                }
                catch (LdapReferralException e) {
                    this.searchReferences = new ArrayList<String>(Arrays.asList(this.readReferralUrls(e)));
                    more = true;
                }
                catch (NamingException e) {
                    ResultCode ignoreRc = this.ignoreSearchException(JndiConnection.this.config.getSearchIgnoreResultCodes(), e);
                    if (ignoreRc == null) {
                        JndiConnection.this.processNamingException(this.request, e, null, this.searchContext);
                    }
                    this.response = JndiConnection.this.createResponse(this.request, null, ignoreRc, null, this.searchContext);
                }
            }
            return more;
        }

        @Override
        public SearchItem next() throws LdapException {
            SearchItem item = null;
            if (this.searchReferences != null) {
                if (!this.searchReferences.isEmpty()) {
                    item = new SearchItem(new SearchReference(-1, null, this.searchReferences.remove(0)));
                }
                if (this.searchReferences.isEmpty()) {
                    this.response = JndiConnection.this.createResponse(this.request, null, ResultCode.SUCCESS, null, this.searchContext);
                }
            } else {
                JndiUtils bu = new JndiUtils(this.request.getSortBehavior());
                try {
                    SearchResult result = this.results.next();
                    JndiConnection.this.logger.trace("reading search result: {}", (Object)result);
                    result.setName(this.formatDn(result, this.getSearchDn(this.searchContext, this.request)));
                    item = new SearchItem(bu.toSearchEntry(result));
                }
                catch (LdapReferralException e) {
                    item = new SearchItem(new SearchReference(-1, null, this.readReferralUrls(e)));
                }
                catch (NamingException e) {
                    ResultCode ignoreRc = this.ignoreSearchException(JndiConnection.this.config.getSearchIgnoreResultCodes(), e);
                    if (ignoreRc == null) {
                        JndiConnection.this.processNamingException(this.request, e, null, this.searchContext);
                    }
                    this.responseResultCode = ignoreRc;
                }
            }
            return item;
        }

        protected ResultCode ignoreSearchException(ResultCode[] ignoreResultCodes, NamingException e) {
            ResultCode ignore = null;
            if (ignoreResultCodes != null && ignoreResultCodes.length > 0) {
                for (ResultCode rc : ignoreResultCodes) {
                    if (!NamingExceptionUtils.matches(e.getClass(), rc)) continue;
                    JndiConnection.this.logger.debug("Ignoring naming exception", (Throwable)e);
                    ignore = rc;
                    break;
                }
            }
            return ignore;
        }

        protected String[] readReferralUrls(LdapReferralException refEx) {
            ArrayList<String> urls = new ArrayList<String>();
            LdapReferralException loopEx = refEx;
            urls.add((String)loopEx.getReferralInfo());
            while (loopEx.skipReferral()) {
                try {
                    LdapContext ctx = (LdapContext)loopEx.getReferralContext(this.searchContext.getEnvironment(), (Control[])JndiConnection.this.config.getControlProcessor().processRequestControls(this.request.getControls()));
                    this.search(ctx, this.request);
                }
                catch (LdapReferralException e) {
                    if (e.getReferralInfo() != null && e.getReferralInfo() instanceof String) {
                        urls.add((String)e.getReferralInfo());
                    }
                    loopEx = e;
                }
                catch (NamingException namingEx) {
                    JndiConnection.this.logger.warn("Error reading search references", (Throwable)namingEx);
                    break;
                }
            }
            JndiConnection.this.logger.trace("read search references: {}", urls);
            return urls.toArray(new String[urls.size()]);
        }

        @Override
        public Response<Void> getResponse() {
            return this.response;
        }

        protected String getSearchDn(LdapContext ctx, SearchRequest sr) throws NamingException {
            if (ctx != null && !"".equals(ctx.getNameInNamespace())) {
                return ctx.getNameInNamespace();
            }
            return sr.getBaseDn();
        }

        protected String formatDn(SearchResult sr, String baseDn) throws NamingException {
            String fqName;
            if (sr.isRelative()) {
                JndiConnection.this.logger.trace("formatting relative dn '{}'", (Object)sr.getNameInNamespace());
                LdapName lname = new LdapName(sr.getNameInNamespace());
                fqName = lname.toString();
            } else {
                JndiConnection.this.logger.trace("formatting non-relative dn '{}'", (Object)sr.getName());
                fqName = JndiConnection.this.config.getRemoveDnUrls() ? this.readCompositeName(URI.create(sr.getName()).getPath().substring(1)) : this.readCompositeName(sr.getName());
            }
            JndiConnection.this.logger.trace("formatted dn '{}'", (Object)fqName);
            return fqName;
        }

        protected String readCompositeName(String s) throws InvalidNameException {
            StringBuilder name = new StringBuilder();
            CompositeName cName = new CompositeName(s);
            for (int i = 0; i < cName.size(); ++i) {
                name.append(cName.get(i));
                if (i + 1 >= cName.size()) continue;
                name.append("/");
            }
            return name.toString();
        }

        @Override
        public void close() throws LdapException {
            try {
                if (this.results != null) {
                    this.results.close();
                }
            }
            catch (NamingException e) {
                JndiConnection.this.logger.error("Error closing naming enumeration", (Throwable)e);
            }
            try {
                if (this.searchContext != null) {
                    this.searchContext.close();
                }
            }
            catch (NamingException e) {
                JndiConnection.this.logger.error("Error closing ldap context", (Throwable)e);
            }
        }
    }
}

