/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.LdapException;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.jndi.JndiConnection;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.NamingExceptionUtils;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;

public class JndiConnectionFactory
extends AbstractProviderConnectionFactory<JndiProviderConfig> {
    private final Map<String, Object> environment;
    private final ClassLoader classLoader;
    private SslConfig threadLocalSslConfig;

    public JndiConnectionFactory(String url, ConnectionStrategy strategy, JndiProviderConfig config, Map<String, Object> env, ClassLoader cl) {
        super(url, strategy, config);
        this.environment = Collections.unmodifiableMap(env);
        this.classLoader = cl;
        if (ThreadLocalTLSSocketFactory.class.getName().equals(this.environment.get("java.naming.ldap.factory.socket"))) {
            ThreadLocalTLSSocketFactory sf = new ThreadLocalTLSSocketFactory();
            this.threadLocalSslConfig = sf.getSslConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JndiConnection createInternal(String url) throws LdapException {
        JndiConnection conn;
        block11: {
            ThreadLocalTLSSocketFactory threadLocalTLSSocketFactory = null;
            if (this.threadLocalSslConfig != null && ThreadLocalTLSSocketFactory.class.getName().equals(this.environment.get("java.naming.ldap.factory.socket"))) {
                threadLocalTLSSocketFactory = new ThreadLocalTLSSocketFactory();
                threadLocalTLSSocketFactory.setSslConfig(this.threadLocalSslConfig);
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>(this.environment);
            env.put("java.naming.provider.url", url);
            try {
                if (this.classLoader != null) {
                    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.classLoader);
                        conn = new JndiConnection(new InitialLdapContext(env, null), (JndiProviderConfig)this.getProviderConfig());
                        break block11;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(currentClassLoader);
                    }
                }
                conn = new JndiConnection(new InitialLdapContext(env, null), (JndiProviderConfig)this.getProviderConfig());
            }
            catch (NamingException e) {
                throw new ConnectionException(e, NamingExceptionUtils.getResultCode(e.getClass()));
            }
            finally {
                if (threadLocalTLSSocketFactory != null) {
                    threadLocalTLSSocketFactory.removeSslConfig();
                }
            }
        }
        return conn;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::metadata=%s, environment=%s, classLoader=%s, providerConfig=%s]", this.getClass().getName(), this.hashCode(), this.getMetadata(), this.environment, this.classLoader, this.getProviderConfig());
    }
}

