/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import retrofit.RequestInterceptor;
import retrofit.RestMethodInfo;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.converter.Converter;
import retrofit.mime.FormUrlEncodedTypedOutput;
import retrofit.mime.MultipartTypedOutput;
import retrofit.mime.TypedOutput;
import retrofit.mime.TypedString;

final class RequestBuilder
implements RequestInterceptor.RequestFacade {
    private final Converter converter;
    private final String[] paramNames;
    private final RestMethodInfo.ParamUsage[] paramUsages;
    private final String requestMethod;
    private final boolean isSynchronous;
    private final boolean isObservable;
    private final String apiUrl;
    private final FormUrlEncodedTypedOutput formBody;
    private final MultipartTypedOutput multipartBody;
    private TypedOutput body;
    private String relativeUrl;
    private StringBuilder queryParams;
    private List<Header> headers;
    private String contentTypeHeader;

    RequestBuilder(String apiUrl, RestMethodInfo methodInfo, Converter converter) {
        this.apiUrl = apiUrl;
        this.converter = converter;
        this.paramNames = methodInfo.requestParamNames;
        this.paramUsages = methodInfo.requestParamUsage;
        this.requestMethod = methodInfo.requestMethod;
        this.isSynchronous = methodInfo.isSynchronous;
        this.isObservable = methodInfo.isObservable;
        if (methodInfo.headers != null) {
            this.headers = new ArrayList<Header>(methodInfo.headers);
        }
        this.contentTypeHeader = methodInfo.contentTypeHeader;
        this.relativeUrl = methodInfo.requestUrl;
        String requestQuery = methodInfo.requestQuery;
        if (requestQuery != null) {
            this.queryParams = new StringBuilder().append('?').append(requestQuery);
        }
        switch (methodInfo.requestType) {
            case FORM_URL_ENCODED: {
                this.formBody = new FormUrlEncodedTypedOutput();
                this.multipartBody = null;
                this.body = this.formBody;
                break;
            }
            case MULTIPART: {
                this.formBody = null;
                this.multipartBody = new MultipartTypedOutput();
                this.body = this.multipartBody;
                break;
            }
            case SIMPLE: {
                this.formBody = null;
                this.multipartBody = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + (Object)((Object)methodInfo.requestType));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null.");
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentTypeHeader = value;
            return;
        }
        List<Header> headers = this.headers;
        if (headers == null) {
            this.headers = headers = new ArrayList<Header>(2);
        }
        headers.add(new Header(name, value));
    }

    @Override
    public void addPathParam(String name, String value) {
        this.addPathParam(name, value, true);
    }

    @Override
    public void addEncodedPathParam(String name, String value) {
        this.addPathParam(name, value, false);
    }

    private void addPathParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Path replacement name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Path replacement \"" + name + "\" value must not be null.");
        }
        try {
            if (urlEncodeValue) {
                String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
                encodedValue = encodedValue.replace("+", "%20");
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", encodedValue);
            } else {
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", String.valueOf(value));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert path parameter \"" + name + "\" value to UTF-8:" + value, e);
        }
    }

    @Override
    public void addQueryParam(String name, String value) {
        this.addQueryParam(name, value, true);
    }

    @Override
    public void addEncodedQueryParam(String name, String value) {
        this.addQueryParam(name, value, false);
    }

    private void addQueryParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Query param name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Query param \"" + name + "\" value must not be null.");
        }
        try {
            StringBuilder queryParams;
            if (urlEncodeValue) {
                value = URLEncoder.encode(String.valueOf(value), "UTF-8");
            }
            if ((queryParams = this.queryParams) == null) {
                this.queryParams = queryParams = new StringBuilder();
            }
            queryParams.append(queryParams.length() > 0 ? (char)'&' : '?');
            queryParams.append(name).append('=').append(value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert query parameter \"" + name + "\" value to UTF-8: " + value, e);
        }
    }

    void setArguments(Object[] args) {
        if (args == null) {
            return;
        }
        int count = args.length;
        if (!this.isSynchronous && !this.isObservable) {
            --count;
        }
        block12: for (int i = 0; i < count; ++i) {
            String name = this.paramNames[i];
            Object value = args[i];
            RestMethodInfo.ParamUsage paramUsage = this.paramUsages[i];
            switch (paramUsage) {
                case PATH: {
                    if (value == null) {
                        throw new IllegalArgumentException("Path parameter \"" + name + "\" value must not be null.");
                    }
                    this.addPathParam(name, value.toString());
                    continue block12;
                }
                case ENCODED_PATH: {
                    if (value == null) {
                        throw new IllegalArgumentException("Path parameter \"" + name + "\" value must not be null.");
                    }
                    this.addEncodedPathParam(name, value.toString());
                    continue block12;
                }
                case QUERY: 
                case ENCODED_QUERY: {
                    boolean urlEncodeValue;
                    if (value == null) continue block12;
                    boolean bl = urlEncodeValue = paramUsage == RestMethodInfo.ParamUsage.QUERY;
                    if (value instanceof Iterable) {
                        for (Object iterableValue : (Iterable)value) {
                            if (iterableValue == null) continue;
                            this.addQueryParam(name, iterableValue.toString(), urlEncodeValue);
                        }
                        continue block12;
                    }
                    if (value.getClass().isArray()) {
                        int arrayLength = Array.getLength(value);
                        for (int x = 0; x < arrayLength; ++x) {
                            Object arrayValue = Array.get(value, x);
                            if (arrayValue == null) continue;
                            this.addQueryParam(name, arrayValue.toString(), urlEncodeValue);
                        }
                        continue block12;
                    }
                    this.addQueryParam(name, value.toString(), urlEncodeValue);
                    continue block12;
                }
                case QUERY_MAP: 
                case ENCODED_QUERY_MAP: {
                    Object entryValue;
                    if (value == null) continue block12;
                    boolean urlEncodeValue = paramUsage == RestMethodInfo.ParamUsage.QUERY_MAP;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.addQueryParam(entry.getKey().toString(), entryValue.toString(), urlEncodeValue);
                    }
                    continue block12;
                }
                case HEADER: {
                    if (value == null) continue block12;
                    this.addHeader(name, value.toString());
                    continue block12;
                }
                case FIELD: {
                    if (value == null) continue block12;
                    if (value instanceof Iterable) {
                        for (Object iterableValue : (Iterable)value) {
                            if (iterableValue == null) continue;
                            this.formBody.addField(name, iterableValue.toString());
                        }
                        continue block12;
                    }
                    if (value.getClass().isArray()) {
                        int arrayLength = Array.getLength(value);
                        for (int x = 0; x < arrayLength; ++x) {
                            Object arrayValue = Array.get(value, x);
                            if (arrayValue == null) continue;
                            this.formBody.addField(name, arrayValue.toString());
                        }
                        continue block12;
                    }
                    this.formBody.addField(name, value.toString());
                    continue block12;
                }
                case FIELD_MAP: {
                    if (value == null) continue block12;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        Object entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.formBody.addField(entry.getKey().toString(), entryValue.toString());
                    }
                    continue block12;
                }
                case PART: {
                    if (value == null) continue block12;
                    if (value instanceof TypedOutput) {
                        this.multipartBody.addPart(name, (TypedOutput)value);
                        continue block12;
                    }
                    if (value instanceof String) {
                        this.multipartBody.addPart(name, new TypedString((String)value));
                        continue block12;
                    }
                    this.multipartBody.addPart(name, this.converter.toBody(value));
                    continue block12;
                }
                case PART_MAP: {
                    Object entryValue;
                    if (value == null) continue block12;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        String entryName = entry.getKey().toString();
                        entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        if (entryValue instanceof TypedOutput) {
                            this.multipartBody.addPart(entryName, (TypedOutput)entryValue);
                            continue;
                        }
                        if (entryValue instanceof String) {
                            this.multipartBody.addPart(entryName, new TypedString((String)entryValue));
                            continue;
                        }
                        this.multipartBody.addPart(entryName, this.converter.toBody(entryValue));
                    }
                    continue block12;
                }
                case BODY: {
                    if (value == null) {
                        throw new IllegalArgumentException("Body parameter value must not be null.");
                    }
                    if (value instanceof TypedOutput) {
                        this.body = (TypedOutput)value;
                        continue block12;
                    }
                    this.body = this.converter.toBody(value);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknown parameter usage: " + (Object)((Object)paramUsage));
                }
            }
        }
    }

    Request build() throws UnsupportedEncodingException {
        if (this.multipartBody != null && this.multipartBody.getPartCount() == 0) {
            throw new IllegalStateException("Multipart requests must contain at least one part.");
        }
        String apiUrl = this.apiUrl;
        StringBuilder url = new StringBuilder(apiUrl);
        if (apiUrl.endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        url.append(this.relativeUrl);
        StringBuilder queryParams = this.queryParams;
        if (queryParams != null) {
            url.append((CharSequence)queryParams);
        }
        TypedOutput body = this.body;
        List<Header> headers = this.headers;
        if (this.contentTypeHeader != null) {
            if (body != null) {
                body = new MimeOverridingTypedOutput(body, this.contentTypeHeader);
            } else {
                headers.add(new Header("Content-Type", this.contentTypeHeader));
            }
        }
        return new Request(this.requestMethod, url.toString(), headers, body);
    }

    private static class MimeOverridingTypedOutput
    implements TypedOutput {
        private final TypedOutput delegate;
        private final String mimeType;

        MimeOverridingTypedOutput(TypedOutput delegate, String mimeType) {
            this.delegate = delegate;
            this.mimeType = mimeType;
        }

        @Override
        public String fileName() {
            return this.delegate.fileName();
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public long length() {
            return this.delegate.length();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.delegate.writeTo(out);
        }
    }
}

