/*
 * Decompiled with CFR 0.152.
 */
package retrofit.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class TypedByteArray
implements TypedInput,
TypedOutput {
    private final String mimeType;
    private final byte[] bytes;

    public TypedByteArray(String mimeType, byte[] bytes) {
        if (mimeType == null) {
            mimeType = "application/unknown";
        }
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String fileName() {
        return null;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes);
    }

    @Override
    public InputStream in() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedByteArray that = (TypedByteArray)o;
        if (!Arrays.equals(this.bytes, that.bytes)) {
            return false;
        }
        return this.mimeType.equals(that.mimeType);
    }

    public int hashCode() {
        int result = this.mimeType.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }
}

