/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.threads;

import java.util.ArrayList;
import java.util.List;

public class RecursiveThreadExecutor {
    int maxThreads;
    List<Job> threads = new ArrayList<Job>();
    List<Task> tasks = new ArrayList<Task>();
    int waitingThreads = 0;

    public RecursiveThreadExecutor(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public RecursiveThreadExecutor() {
        this.maxThreads = Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.maxThreads = 0;
            for (Job j : this.threads) {
                j.interrupt();
            }
        }
    }

    public void join() throws InterruptedException {
        for (Job j : this.threads) {
            j.join();
        }
        this.threads.clear();
    }

    public void close() throws InterruptedException {
        this.interrupt();
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task t) {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.tasks.add(t);
            if (this.waitingThreads == 0) {
                if (this.threads.size() < this.maxThreads) {
                    this.createThread();
                }
            } else {
                this.tasks.notify();
            }
        }
    }

    void createThread() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Job t = new Job();
        this.threads.add(t);
        t.start();
    }

    Task waitForNewTask() throws InterruptedException {
        return this.waitForNewTask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Task waitForNewTask(Task taskEnd) throws InterruptedException {
        List<Task> list = this.tasks;
        synchronized (list) {
            ++this.waitingThreads;
            try {
                Task task;
                if (this.tasks.size() == 0) {
                    if (taskEnd != null) {
                        task = taskEnd;
                        synchronized (task) {
                            if (taskEnd.end) {
                                Task task2 = null;
                                return task2;
                            }
                        }
                    }
                    this.tasks.wait();
                    if (this.tasks.size() == 0) {
                        task = null;
                        return task;
                    }
                }
                task = this.tasks.remove(0);
                return task;
            }
            finally {
                --this.waitingThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTaskEnd(Task t) throws InterruptedException {
        while (true) {
            Task tt;
            if ((tt = this.waitForNewTask(t)) != null) {
                this.executeTaskFlag(tt);
                continue;
            }
            Task task = t;
            synchronized (task) {
                if (t.end) {
                    return;
                }
            }
        }
    }

    public void waitTermination(Task t) throws InterruptedException {
        if (!this.executeTaskFlag(t)) {
            this.waitTaskEnd(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeTaskFlag(Task t) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Current Thread Interrupted");
        }
        Object object = t;
        synchronized (object) {
            if (t.interrupted()) {
                throw new InterruptedException("Parent Task Interrupted");
            }
            if (t.end) {
                return true;
            }
            if (t.start) {
                return false;
            }
            t.start = true;
        }
        try {
            t.run();
        }
        finally {
            object = t;
            synchronized (object) {
                t.end = true;
            }
            object = this.tasks;
            synchronized (object) {
                this.tasks.notifyAll();
            }
        }
        return true;
    }

    class Job
    extends Thread {
        public Job() {
            super("RecursiveThread - " + RecursiveThreadExecutor.this.threads.size());
        }

        @Override
        public void run() {
            while (true) {
                Task t = null;
                try {
                    t = RecursiveThreadExecutor.this.waitForNewTask();
                    if (t == null) continue;
                    RecursiveThreadExecutor.this.executeTaskFlag(t);
                    continue;
                }
                catch (Error e) {
                    if (t == null) continue;
                    t.e = e;
                    continue;
                }
                catch (RuntimeException e) {
                    if (t == null) continue;
                    t.e = e;
                    continue;
                }
                catch (InterruptedException e) {
                    if (t != null) {
                        t.e = e;
                    }
                    return;
                }
                break;
            }
        }
    }

    public static class Task
    implements Runnable {
        Throwable e;
        Runnable r;
        boolean start = false;
        boolean end = false;

        public Task(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            this.r.run();
        }

        public boolean interrupted() {
            return false;
        }
    }
}

