/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.AbstractCentralAuthenticationService;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.exceptions.MixedPrincipalException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.support.events.ticket.CasProxyGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasProxyTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketValidatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.UnrecognizableServiceForServiceTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

@Transactional(transactionManager="ticketTransactionManager")
public class DefaultCentralAuthenticationService
extends AbstractCentralAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCentralAuthenticationService.class);
    private static final long serialVersionUID = -8943828074939533986L;

    public DefaultCentralAuthenticationService(ApplicationEventPublisher applicationEventPublisher, TicketRegistry ticketRegistry, ServicesManager servicesManager, LogoutManager logoutManager, TicketFactory ticketFactory, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory, PrincipalFactory principalFactory, CipherExecutor<String, String> cipherExecutor, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(applicationEventPublisher, ticketRegistry, servicesManager, logoutManager, ticketFactory, authenticationRequestServiceSelectionStrategies, serviceContextAuthenticationPolicyFactory, principalFactory, cipherExecutor, registeredServiceAccessStrategyEnforcer);
    }

    @Audit(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="DESTROY_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="DESTROY_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="DESTROY_TICKET_GRANTING_TICKET_METER")
    @Counted(name="DESTROY_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public List<LogoutRequest> destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        try {
            LOGGER.debug("Removing ticket [{}] from registry...", (Object)ticketGrantingTicketId);
            TicketGrantingTicket ticket = this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            LOGGER.debug("Ticket found. Processing logout requests and then deleting the ticket...");
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)ticket.getAuthentication());
            List logoutRequests = this.logoutManager.performLogout(ticket);
            this.deleteTicket(ticketGrantingTicketId);
            this.doPublishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, ticket));
            return logoutRequests;
        }
        catch (InvalidTicketException e) {
            LOGGER.debug("TicketGrantingTicket [{}] cannot be found in the ticket registry.", (Object)ticketGrantingTicketId);
            return new ArrayList<LogoutRequest>(0);
        }
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_SERVICE_TICKET_TIMER")
    @Metered(name="GRANT_SERVICE_TICKET_METER")
    @Counted(name="GRANT_SERVICE_TICKET_COUNTER", monotonic=true)
    public ServiceTicket grantServiceTicket(String ticketGrantingTicketId, Service service, AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        boolean credentialProvided = authenticationResult != null && authenticationResult.isCredentialProvided();
        TicketGrantingTicket ticketGrantingTicket = this.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        Service selectedService = this.resolveServiceFromAuthenticationRequest(service);
        RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
        AuditableContext audit = AuditableContext.builder().service(selectedService).ticketGrantingTicket(ticketGrantingTicket).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        Authentication currentAuthentication = DefaultCentralAuthenticationService.evaluatePossibilityOfMixedPrincipals(authenticationResult, ticketGrantingTicket);
        RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)selectedService, (TicketGrantingTicket)ticketGrantingTicket, (boolean)credentialProvided);
        this.evaluateProxiedServiceIfNeeded(selectedService, ticketGrantingTicket, registeredService);
        this.getAuthenticationSatisfiedByPolicy(currentAuthentication, new ServiceContext(selectedService, registeredService));
        Authentication latestAuthentication = ticketGrantingTicket.getRoot().getAuthentication();
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)latestAuthentication);
        Principal principal = latestAuthentication.getPrincipal();
        ServiceTicketFactory factory = (ServiceTicketFactory)this.ticketFactory.get(ServiceTicket.class);
        ServiceTicket serviceTicket = (ServiceTicket)factory.create(ticketGrantingTicket, service, credentialProvided, ServiceTicket.class);
        this.ticketRegistry.updateTicket((Ticket)ticketGrantingTicket);
        this.ticketRegistry.addTicket((Ticket)serviceTicket);
        LOGGER.info("Granted ticket [{}] for service [{}] and principal [{}]", new Object[]{serviceTicket.getId(), DigestUtils.abbreviate((String)service.getId()), principal.getId()});
        this.doPublishEvent((ApplicationEvent)new CasServiceTicketGrantedEvent((Object)this, ticketGrantingTicket, serviceTicket));
        return serviceTicket;
    }

    @Audit(action="PROXY_TICKET", actionResolverName="GRANT_PROXY_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_TICKET_RESOURCE_RESOLVER")
    @Timed(name="GRANT_PROXY_TICKET_TIMER")
    @Metered(name="GRANT_PROXY_TICKET_METER")
    @Counted(name="GRANT_PROXY_TICKET_COUNTER", monotonic=true)
    public ProxyTicket grantProxyTicket(String proxyGrantingTicket, Service service) throws AbstractTicketException {
        ProxyGrantingTicket proxyGrantingTicketObject = this.getTicket(proxyGrantingTicket, ProxyGrantingTicket.class);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        try {
            AuditableContext audit = AuditableContext.builder().service(service).ticketGrantingTicket((TicketGrantingTicket)proxyGrantingTicketObject).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)service, (TicketGrantingTicket)proxyGrantingTicketObject);
        }
        catch (PrincipalException e) {
            throw new UnauthorizedSsoServiceException();
        }
        this.evaluateProxiedServiceIfNeeded(service, (TicketGrantingTicket)proxyGrantingTicketObject, registeredService);
        this.getAuthenticationSatisfiedByPolicy(proxyGrantingTicketObject.getRoot().getAuthentication(), new ServiceContext(service, registeredService));
        Authentication authentication = proxyGrantingTicketObject.getRoot().getAuthentication();
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
        Principal principal = authentication.getPrincipal();
        ProxyTicketFactory factory = (ProxyTicketFactory)this.ticketFactory.get(ProxyTicket.class);
        ProxyTicket proxyTicket = (ProxyTicket)factory.create(proxyGrantingTicketObject, service, ProxyTicket.class);
        this.ticketRegistry.updateTicket((Ticket)proxyGrantingTicketObject);
        this.ticketRegistry.addTicket((Ticket)proxyTicket);
        LOGGER.info("Granted ticket [{}] for service [{}] for user [{}]", new Object[]{proxyTicket.getId(), service.getId(), principal.getId()});
        this.doPublishEvent((ApplicationEvent)new CasProxyTicketGrantedEvent((Object)this, proxyGrantingTicketObject, proxyTicket));
        return proxyTicket;
    }

    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="CREATE_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="CREATE_PROXY_GRANTING_TICKET_TIMER")
    @Metered(name="CREATE_PROXY_GRANTING_TICKET_METER")
    @Counted(name="CREATE_PROXY_GRANTING_TICKET_COUNTER", monotonic=true)
    public ProxyGrantingTicket createProxyGrantingTicket(String serviceTicketId, AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authenticationResult.getAuthentication());
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            LOGGER.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(serviceTicket.getService());
        AuditableContext ctx = AuditableContext.builder().serviceTicket(serviceTicket).authenticationResult(authenticationResult).registeredService(registeredService).build();
        AuditableExecutionResult result = this.registeredServiceAccessStrategyEnforcer.execute(ctx);
        result.throwExceptionIfNeeded();
        if (!registeredService.getProxyPolicy().isAllowedToProxy()) {
            LOGGER.warn("ServiceManagement: Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        Authentication authentication = authenticationResult.getAuthentication();
        ProxyGrantingTicketFactory factory = (ProxyGrantingTicketFactory)this.ticketFactory.get(ProxyGrantingTicket.class);
        ProxyGrantingTicket proxyGrantingTicket = factory.create(serviceTicket, authentication, ProxyGrantingTicket.class);
        LOGGER.debug("Generated proxy granting ticket [{}] based off of [{}]", (Object)proxyGrantingTicket, (Object)serviceTicketId);
        this.ticketRegistry.addTicket((Ticket)proxyGrantingTicket);
        this.doPublishEvent((ApplicationEvent)new CasProxyGrantingTicketCreatedEvent((Object)this, (TicketGrantingTicket)proxyGrantingTicket));
        return proxyGrantingTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    @Timed(name="VALIDATE_SERVICE_TICKET_TIMER")
    @Metered(name="VALIDATE_SERVICE_TICKET_METER")
    @Counted(name="VALIDATE_SERVICE_TICKET_COUNTER", monotonic=true)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws AbstractTicketException {
        if (!this.isTicketAuthenticityVerified(serviceTicketId)) {
            LOGGER.info("Service ticket [{}] is not a valid ticket issued by CAS.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            LOGGER.warn("Service ticket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        try {
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    LOGGER.info("ServiceTicket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!serviceTicket.isValidFor(service)) {
                    LOGGER.error("Service ticket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), service});
                    throw new UnrecognizableServiceForServiceTicketValidationException(serviceTicket.getService());
                }
            }
            Service selectedService = this.resolveServiceFromAuthenticationRequest(serviceTicket.getService());
            LOGGER.debug("Resolved service [{}] from the authentication request", (Object)selectedService);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            LOGGER.debug("Located registered service definition [{}] from [{}] to handle validation request", (Object)registeredService, (Object)selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
            TicketGrantingTicket root = serviceTicket.getTicketGrantingTicket().getRoot();
            Authentication authentication = this.getAuthenticationSatisfiedByPolicy(root.getAuthentication(), new ServiceContext(selectedService, registeredService));
            Principal principal = authentication.getPrincipal();
            RegisteredServiceAttributeReleasePolicy attributePolicy = registeredService.getAttributeReleasePolicy();
            LOGGER.debug("Attribute policy [{}] is associated with service [{}]", (Object)attributePolicy, (Object)registeredService);
            HashMap attributesToRelease = attributePolicy != null ? attributePolicy.getAttributes(principal, selectedService, registeredService) : new HashMap();
            LOGGER.debug("Calculated attributes for release per the release policy are [{}]", attributesToRelease.keySet());
            String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, selectedService, registeredService);
            Principal modifiedPrincipal = this.principalFactory.createPrincipal(principalId, attributesToRelease);
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance((Authentication)authentication);
            builder.setPrincipal(modifiedPrincipal);
            LOGGER.debug("Principal determined for release to [{}] is [{}]", (Object)registeredService.getServiceId(), (Object)principalId);
            Authentication finalAuthentication = builder.build();
            AuditableContext audit = AuditableContext.builder().service(selectedService).authentication(finalAuthentication).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)finalAuthentication);
            Assertion assertion = new DefaultAssertionBuilder(finalAuthentication).with(selectedService).with(serviceTicket.getTicketGrantingTicket().getChainedAuthentications()).with(serviceTicket.isFromNewLogin()).build();
            this.doPublishEvent((ApplicationEvent)new CasServiceTicketValidatedEvent((Object)this, serviceTicket, assertion));
            Assertion assertion2 = assertion;
            return assertion2;
        }
        finally {
            if (serviceTicket.isExpired()) {
                this.deleteTicket(serviceTicketId);
            } else {
                this.ticketRegistry.updateTicket((Ticket)serviceTicket);
            }
        }
    }

    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    @Timed(name="CREATE_TICKET_GRANTING_TICKET_TIMER")
    @Metered(name="CREATE_TICKET_GRANTING_TICKET_METER")
    @Counted(name="CREATE_TICKET_GRANTING_TICKET_COUNTER", monotonic=true)
    public TicketGrantingTicket createTicketGrantingTicket(AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        Authentication authentication = authenticationResult.getAuthentication();
        Service service = authenticationResult.getService();
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
        if (service != null) {
            Service selectedService = this.resolveServiceFromAuthenticationRequest(service);
            LOGGER.debug("Resolved service [{}] from the authentication request", (Object)selectedService);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService(registeredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.FALSE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
        }
        TicketGrantingTicketFactory factory = (TicketGrantingTicketFactory)this.ticketFactory.get(TicketGrantingTicket.class);
        TicketGrantingTicket ticketGrantingTicket = factory.create(authentication, TicketGrantingTicket.class);
        this.ticketRegistry.addTicket((Ticket)ticketGrantingTicket);
        this.doPublishEvent((ApplicationEvent)new CasTicketGrantingTicketCreatedEvent((Object)this, ticketGrantingTicket));
        return ticketGrantingTicket;
    }

    private static Authentication evaluatePossibilityOfMixedPrincipals(AuthenticationResult context, TicketGrantingTicket ticketGrantingTicket) throws MixedPrincipalException {
        Authentication currentAuthentication = null;
        if (context != null && (currentAuthentication = context.getAuthentication()) != null) {
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!currentAuthentication.getPrincipal().equals(original.getPrincipal())) {
                throw new MixedPrincipalException(currentAuthentication, currentAuthentication.getPrincipal(), original.getPrincipal());
            }
        }
        return currentAuthentication;
    }
}

