/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.dao;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.util.DateTimeUtils;
import org.hibernate.annotations.GenericGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;

@Entity
@Table(name="CasEvent")
public class CasEvent {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEvent.class);
    @Id
    @javax.persistence.Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private long id = -1L;
    @Column(nullable=false)
    private String type;
    @Column(nullable=false)
    private String principalId;
    @Column(nullable=false)
    private String creationTime;
    @ElementCollection
    @MapKeyColumn(name="name")
    @Column(name="value")
    @CollectionTable(name="events_properties", joinColumns={@JoinColumn(name="id")})
    private Map<String, String> properties = new HashMap<String, String>();

    public CasEvent() {
        this.id = System.currentTimeMillis();
    }

    public ZonedDateTime getCreationTime() {
        ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((String)this.creationTime);
        if (dt != null) {
            return dt;
        }
        LocalDateTime lt = DateTimeUtils.localDateTimeOf((String)this.creationTime);
        return DateTimeUtils.zonedDateTimeOf((TemporalAccessor)lt.atZone(ZoneId.systemDefault()));
    }

    public void putTimestamp(Long time) {
        this.put("timestamp", time.toString());
    }

    public void putId(String id) {
        this.put("id", id);
    }

    public void putClientIpAddress(String loc) {
        this.put("clientip", loc);
    }

    public void putServerIpAddress(String loc) {
        this.put("serverip", loc);
    }

    public void putAgent(String dev) {
        this.put("agent", dev);
    }

    public Long getTimestamp() {
        return Long.valueOf(this.get("timestamp"));
    }

    public String getAgent() {
        return this.get("agent");
    }

    public String getId() {
        return this.get("id");
    }

    public String getClientIpAddress() {
        return this.get("clientip");
    }

    public String getServerIpAddress() {
        return this.get("serverip");
    }

    public void put(String key, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    private void putGeoLatitude(String s) {
        this.put("geoLatitude", s);
    }

    private void putGeoLongitude(String s) {
        this.put("geoLongitude", s);
    }

    private void putGeoAccuracy(String s) {
        this.put("geoAccuracy", s);
    }

    private void putGeoTimestamp(String s) {
        this.put("geoTimestamp", s);
    }

    public void putGeoLocation(GeoLocationRequest location) {
        this.putGeoAccuracy(location.getAccuracy());
        this.putGeoLatitude(location.getLatitude());
        this.putGeoLongitude(location.getLongitude());
        this.putGeoTimestamp(location.getTimestamp());
    }

    public GeoLocationRequest getGeoLocation() {
        GeoLocationRequest request = new GeoLocationRequest();
        request.setAccuracy(this.get("geoAccuracy"));
        request.setTimestamp(this.get("geoTimestamp"));
        request.setLongitude(this.get("geoLongitude"));
        request.setLatitude(this.get("geoLatitude"));
        return request;
    }

    @Generated
    public String toString() {
        return "CasEvent(id=" + this.id + ", type=" + this.type + ", principalId=" + this.principalId + ", creationTime=" + this.creationTime + ", properties=" + this.properties + ")";
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getPrincipalId() {
        return this.principalId;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    @Generated
    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

