/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.File;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class CasConfigurationPropertiesEnvironmentManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationPropertiesEnvironmentManager.class);
    @NonNull
    private final ConfigurationPropertiesBindingPostProcessor binder;
    private final Environment environment;

    public File getStandaloneProfileConfigurationDirectory() {
        return (File)this.environment.getProperty("cas.standalone.configurationDirectory", File.class, (Object)new File("/etc/cas/config"));
    }

    public File getStandaloneProfileConfigurationFile() {
        return (File)this.environment.getProperty("cas.standalone.configurationFile", File.class);
    }

    public String getApplicationName() {
        return this.environment.getRequiredProperty("spring.application.name");
    }

    public void savePropertyForStandaloneProfile(Pair<String, String> pair) {
        File file = this.getStandaloneProfileConfigurationDirectory();
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFile(new File(file, this.getApplicationName() + ".properties"))});
        Configuration config = (Configuration)builder.getConfiguration();
        config.setProperty((String)pair.getKey(), pair.getValue());
        builder.save();
    }

    public void rebindCasConfigurationProperties(ApplicationContext applicationContext) {
        CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.binder, applicationContext);
    }

    public static void rebindCasConfigurationProperties(ConfigurationPropertiesBindingPostProcessor binder, ApplicationContext applicationContext) {
        Map map = applicationContext.getBeansOfType(CasConfigurationProperties.class);
        String name = (String)map.keySet().iterator().next();
        LOGGER.debug("Reloading CAS configuration via [{}]", (Object)name);
        Object e = applicationContext.getBean(name);
        binder.postProcessBeforeInitialization(e, name);
        Object bean = applicationContext.getAutowireCapableBeanFactory().initializeBean(e, name);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        LOGGER.debug("Reloaded CAS configuration [{}]", (Object)name);
    }

    @Generated
    public CasConfigurationPropertiesEnvironmentManager(@NonNull ConfigurationPropertiesBindingPostProcessor binder, Environment environment) {
        if (binder == null) {
            throw new NullPointerException("binder is marked @NonNull but is null");
        }
        this.binder = binder;
        this.environment = environment;
    }

    @NonNull
    @Generated
    public ConfigurationPropertiesBindingPostProcessor getBinder() {
        return this.binder;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }
}

