/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.DefaultLogoutExecutionPlan;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutMessageCreator;
import org.apereo.cas.logout.SamlCompliantLogoutMessageCreator;
import org.apereo.cas.logout.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.SingleLogoutServiceMessageHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreLogoutConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreLogoutConfiguration
implements LogoutExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreLogoutConfiguration.class);
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="noRedirectHttpClient")
    private HttpClient httpClient;
    @Autowired
    private UrlValidator urlValidator;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;

    @ConditionalOnMissingBean(name={"singleLogoutServiceLogoutUrlBuilder"})
    @Bean
    public SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder() {
        return new DefaultSingleLogoutServiceLogoutUrlBuilder(this.urlValidator);
    }

    @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceMessageHandler"})
    @Bean
    public SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler() {
        return new DefaultSingleLogoutServiceMessageHandler(this.httpClient, this.logoutBuilder(), this.servicesManager, this.singleLogoutServiceLogoutUrlBuilder(), this.casProperties.getSlo().isAsynchronous(), (AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"logoutManager"})
    @RefreshScope
    @Autowired
    @Bean
    public LogoutManager logoutManager(@Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
        return new DefaultLogoutManager(this.logoutBuilder(), this.defaultSingleLogoutServiceMessageHandler(), this.casProperties.getSlo().isDisabled(), logoutExecutionPlan);
    }

    @ConditionalOnMissingBean(name={"logoutBuilder"})
    @Bean
    public LogoutMessageCreator logoutBuilder() {
        return new SamlCompliantLogoutMessageCreator();
    }

    @ConditionalOnMissingBean(name={"logoutExecutionPlan"})
    @Autowired
    @Bean
    public LogoutExecutionPlan logoutExecutionPlan(List<LogoutExecutionPlanConfigurer> configurers) {
        DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring logout execution plan [{}]", (Object)name);
            c.configureLogoutExecutionPlan((LogoutExecutionPlan)plan);
        });
        return plan;
    }

    public void configureLogoutExecutionPlan(LogoutExecutionPlan plan) {
        if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
            LOGGER.debug("CAS is configured to remove descendant tickets of the ticket-granting tickets");
            plan.registerLogoutHandler(ticketGrantingTicket -> ticketGrantingTicket.getDescendantTickets().stream().forEach(t -> {
                LOGGER.debug("Deleting ticket [{}] from the registry as a descendant of [{}]", t, (Object)ticketGrantingTicket.getId());
                this.ticketRegistry.deleteTicket(t);
            }));
        }
    }
}

