/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceDelegatedAuthenticationPolicy
implements RegisteredServiceDelegatedAuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceDelegatedAuthenticationPolicy.class);
    private static final long serialVersionUID = -784106970642770923L;
    private Collection<String> allowedProviders = new LinkedHashSet<String>();

    @JsonIgnore
    public boolean isProviderAllowed(String provider, RegisteredService registeredService) {
        if (this.allowedProviders != null && this.allowedProviders.isEmpty()) {
            LOGGER.warn("Registered service [{}] does not define any authorized/supported delegated authentication providers. It is STRONGLY recommended that you authorize and assign providers to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
            return true;
        }
        return this.allowedProviders.contains(provider);
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceDelegatedAuthenticationPolicy(allowedProviders=" + this.allowedProviders + ")";
    }

    @Generated
    public Collection<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Generated
    public void setAllowedProviders(Collection<String> allowedProviders) {
        this.allowedProviders = allowedProviders;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceDelegatedAuthenticationPolicy)) {
            return false;
        }
        DefaultRegisteredServiceDelegatedAuthenticationPolicy other = (DefaultRegisteredServiceDelegatedAuthenticationPolicy)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceDelegatedAuthenticationPolicy;
    }

    @Generated
    public int hashCode() {
        int result = 1;
        return result;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy(Collection<String> allowedProviders) {
        this.allowedProviders = allowedProviders;
    }

    @Generated
    public DefaultRegisteredServiceDelegatedAuthenticationPolicy() {
    }
}

