/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Optional;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.inspektr.audit.annotation.Audit;

public class RegisteredServiceAccessStrategyAuditableEnforcer
extends BaseAuditableExecution {
    @Audit(action="SERVICE_ACCESS_ENFORCEMENT", actionResolverName="SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER", resourceResolverName="SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER")
    public AuditableExecutionResult execute(AuditableContext context) {
        Optional registeredService = context.getRegisteredService();
        if (context.getServiceTicket().isPresent() && context.getAuthenticationResult().isPresent() && registeredService.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((AuditableContext)context);
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((ServiceTicket)context.getServiceTicket().get(), (AuthenticationResult)context.getAuthenticationResult().get(), (RegisteredService)registeredService.get());
            }
            catch (PrincipalException e) {
                result.setException((RuntimeException)((Object)e));
            }
            return result;
        }
        Optional service = context.getService();
        Optional ticketGrantingTicket = context.getTicketGrantingTicket();
        if (service.isPresent() && registeredService.isPresent() && ticketGrantingTicket.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((Service)((Service)service.get()), (RegisteredService)((RegisteredService)registeredService.get()), (TicketGrantingTicket)((TicketGrantingTicket)ticketGrantingTicket.get()));
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service.get(), (RegisteredService)registeredService.get(), (TicketGrantingTicket)ticketGrantingTicket.get(), (boolean)context.getRetrievePrincipalAttributesFromReleasePolicy().orElse(Boolean.TRUE));
            }
            catch (PrincipalException e) {
                result.setException((RuntimeException)((Object)e));
            }
            return result;
        }
        Optional authentication = context.getAuthentication();
        if (service.isPresent() && registeredService.isPresent() && authentication.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((Authentication)((Authentication)authentication.get()), (Service)((Service)service.get()), (RegisteredService)((RegisteredService)registeredService.get()));
            try {
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service.get(), (RegisteredService)registeredService.get(), (Authentication)authentication.get(), (boolean)context.getRetrievePrincipalAttributesFromReleasePolicy().orElse(Boolean.TRUE));
            }
            catch (PrincipalException e) {
                result.setException((RuntimeException)((Object)e));
            }
            return result;
        }
        if (service.isPresent() && registeredService.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((Service)((Service)service.get()), (RegisteredService)((RegisteredService)registeredService.get()));
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service.get(), (RegisteredService)registeredService.get());
            }
            catch (PrincipalException e) {
                result.setException((RuntimeException)((Object)e));
            }
            return result;
        }
        if (registeredService.isPresent()) {
            AuditableExecutionResult result = AuditableExecutionResult.of((RegisteredService)((RegisteredService)registeredService.get()));
            try {
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService.get());
            }
            catch (PrincipalException e) {
                result.setException((RuntimeException)((Object)e));
            }
            return result;
        }
        throw new UnauthorizedServiceException("screen.service.error.message", "Service unauthorized");
    }
}

