/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Optional;
import javax.crypto.Cipher;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServicePublicKeyCipherExecutor
implements RegisteredServiceCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicePublicKeyCipherExecutor.class);

    public String encode(String data, Optional<RegisteredService> service) {
        try {
            RegisteredService registeredService;
            PublicKey publicKey;
            byte[] result;
            if (service.isPresent() && (result = RegisteredServicePublicKeyCipherExecutor.encodeInternal(data, publicKey = RegisteredServicePublicKeyCipherExecutor.createRegisteredServicePublicKey(registeredService = service.get()), registeredService)) != null) {
                return EncodingUtils.encodeBase64((byte[])result);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String decode(String data, Optional<RegisteredService> service) {
        LOGGER.warn("Operation is not supported by this cipher");
        return null;
    }

    protected static byte[] encodeInternal(String data, PublicKey publicKey, RegisteredService registeredService) {
        Cipher cipher = RegisteredServicePublicKeyCipherExecutor.initializeCipherBasedOnServicePublicKey(publicKey, registeredService);
        if (cipher != null) {
            LOGGER.debug("Initialized cipher successfully. Proceeding to finalize...");
            return cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private static PublicKey createRegisteredServicePublicKey(RegisteredService registeredService) {
        if (registeredService.getPublicKey() == null) {
            LOGGER.debug("No public key is defined for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        PublicKey publicKey = registeredService.getPublicKey().createInstance();
        if (publicKey == null) {
            LOGGER.debug("No public key instance created for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        return publicKey;
    }

    private static Cipher initializeCipherBasedOnServicePublicKey(PublicKey publicKey, RegisteredService registeredService) {
        try {
            LOGGER.debug("Using service [{}] public key [{}] to initialize the cipher", (Object)registeredService.getServiceId(), (Object)registeredService.getPublicKey());
            Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
            cipher.init(1, publicKey);
            LOGGER.debug("Initialized cipher in encrypt-mode via the public key algorithm [{}] for service [{}]", (Object)publicKey.getAlgorithm(), (Object)registeredService.getServiceId());
            return cipher;
        }
        catch (Exception e) {
            LOGGER.warn("Cipher could not be initialized for service [{}]. Error [{}]", (Object)registeredService, (Object)e.getMessage());
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

