/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.AbstractServicesManager;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class DomainServicesManager
extends AbstractServicesManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainServicesManager.class);
    private static final long serialVersionUID = -8581398063126547772L;
    private static final String DEFAULT_DOMAIN_NAME = "default";
    private final Map<String, TreeSet<RegisteredService>> domains = new ConcurrentHashMap<String, TreeSet<RegisteredService>>();
    private final Pattern domainExtractor = RegexUtils.createPattern((String)"^\\^?https?\\??://(.*?)(?:[(]?[:/]|$)");
    private final Pattern domainPattern = RegexUtils.createPattern((String)"^[a-z0-9-.]*$");

    public DomainServicesManager(ServiceRegistry serviceRegistry, ApplicationEventPublisher eventPublisher) {
        super(serviceRegistry, eventPublisher);
    }

    @Override
    protected void deleteInternal(RegisteredService service) {
        String domain = this.extractDomain(service.getServiceId());
        this.domains.get(domain).remove(service);
    }

    @Override
    protected Collection<RegisteredService> getCandidateServicesToMatch(String serviceId) {
        String mappedDomain = StringUtils.isNotBlank((CharSequence)serviceId) ? this.extractDomain(serviceId) : "";
        LOGGER.debug("Domain mapped to the service identifier is [{}]", (Object)mappedDomain);
        String domain = this.domains.containsKey(mappedDomain) ? mappedDomain : DEFAULT_DOMAIN_NAME;
        LOGGER.debug("Looking up services under domain [{}] for service identifier [{}]", (Object)domain, (Object)serviceId);
        Collection<RegisteredService> registeredServices = this.getServicesForDomain(domain);
        if (registeredServices == null || registeredServices.isEmpty()) {
            LOGGER.debug("No services could be located for domain [{}]", (Object)domain);
            return new ArrayList<RegisteredService>(0);
        }
        return registeredServices;
    }

    @Override
    protected void saveInternal(RegisteredService service) {
        this.addToDomain(service, this.domains);
    }

    @Override
    protected void loadInternal() {
        ConcurrentHashMap localDomains = new ConcurrentHashMap();
        this.getAllServices().forEach(r -> this.addToDomain((RegisteredService)r, localDomains));
        this.domains.clear();
        this.domains.putAll(localDomains);
    }

    public List<String> getDomains() {
        return this.domains.keySet().stream().sorted().collect(Collectors.toList());
    }

    public Collection<RegisteredService> getServicesForDomain(String domain) {
        return this.domains.containsKey(domain) ? (Collection)this.domains.get(domain) : new ArrayList<RegisteredService>();
    }

    private String extractDomain(String service) {
        Matcher extractor = this.domainExtractor.matcher(service.toLowerCase());
        return extractor.lookingAt() ? this.validateDomain(extractor.group(1)) : DEFAULT_DOMAIN_NAME;
    }

    private String validateDomain(String providedDomain) {
        String domain = StringUtils.remove((String)providedDomain, (String)"\\");
        Matcher match = this.domainPattern.matcher(StringUtils.remove((String)domain, (String)"\\"));
        return match.matches() ? domain : DEFAULT_DOMAIN_NAME;
    }

    private void addToDomain(RegisteredService r, Map<String, TreeSet<RegisteredService>> map) {
        String domain = this.extractDomain(r.getServiceId());
        TreeSet<Object> services = map.containsKey(domain) ? map.get(domain) : new TreeSet();
        LOGGER.debug("Added service [{}] mapped to domain definition [{}]", (Object)r, (Object)domain);
        services.add(r);
        map.put(domain, services);
    }
}

