/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryInitializer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryInitializer.class);
    private final ServiceRegistry jsonServiceRegistry;
    private final ServiceRegistry serviceRegistry;
    private final ServicesManager servicesManager;

    public void initServiceRegistryIfNecessary() {
        long size = this.serviceRegistry.size();
        LOGGER.debug("Service registry contains [{}] service definition(s)", (Object)size);
        LOGGER.warn("Service registry [{}] will be auto-initialized from JSON service definitions. This behavior is only useful for testing purposes and MAY NOT be appropriate for production. Consider turning off this behavior via the setting [cas.serviceRegistry.initFromJson=false] and explicitly register definitions in the services registry.", (Object)this.serviceRegistry.getName());
        List servicesLoaded = this.jsonServiceRegistry.load();
        LOGGER.debug("Loading JSON services are [{}]", (Object)servicesLoaded);
        servicesLoaded.stream().filter(s -> !this.findExistingMatchForService((RegisteredService)s)).forEach(r -> {
            LOGGER.debug("Initializing service registry with the [{}] JSON service definition...", r);
            this.serviceRegistry.save(r);
        });
        this.servicesManager.load();
        LOGGER.info("Service registry [{}] contains [{}] service definitions", (Object)this.serviceRegistry.getName(), (Object)this.servicesManager.count());
    }

    private boolean findExistingMatchForService(RegisteredService r) {
        RegisteredService match = this.serviceRegistry.findServiceById(r.getServiceId());
        if (match != null) {
            LOGGER.warn("Skipping [{}] JSON service definition as a matching service [{}] is found in the registry", (Object)r.getName(), (Object)match.getName());
            return true;
        }
        match = this.serviceRegistry.findServiceByExactServiceId(r.getServiceId());
        if (match != null) {
            LOGGER.warn("Skipping [{}] JSON service definition as a matching service [{}] is found in the registry", (Object)r.getName(), (Object)match.getName());
            return true;
        }
        match = this.serviceRegistry.findServiceById(r.getId());
        if (match != null) {
            LOGGER.warn("Skipping [{}] JSON service definition as a matching id [{}] is found in the registry", (Object)r.getName(), (Object)match.getId());
            return true;
        }
        return false;
    }

    @Generated
    public ServiceRegistryInitializer(ServiceRegistry jsonServiceRegistry, ServiceRegistry serviceRegistry, ServicesManager servicesManager) {
        this.jsonServiceRegistry = jsonServiceRegistry;
        this.serviceRegistry = serviceRegistry;
        this.servicesManager = servicesManager;
    }
}

