/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ResourceBasedServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.replication.NoOpRegisteredServiceReplicationStrategy;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.BaseResourceBasedRegisteredServiceWatcher;
import org.apereo.cas.services.resource.CreateResourceBasedRegisteredServiceWatcher;
import org.apereo.cas.services.resource.DefaultRegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.resource.DeleteResourceBasedRegisteredServiceWatcher;
import org.apereo.cas.services.resource.ModifyResourceBasedRegisteredServiceWatcher;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.apereo.cas.support.events.service.CasRegisteredServiceDeletedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicePreDeleteEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.io.PathWatcherService;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public abstract class AbstractResourceBasedServiceRegistry
extends AbstractServiceRegistry
implements ResourceBasedServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceBasedServiceRegistry.class);
    private static final String PATTERN_REGISTERED_SERVICE_FILE_NAME = "(\\w+)-(\\d+)\\.";
    private static final BinaryOperator<RegisteredService> LOG_DUPLICATE_AND_RETURN_FIRST_ONE = (s1, s2) -> {
        BaseResourceBasedRegisteredServiceWatcher.LOG_SERVICE_DUPLICATE.accept((RegisteredService)s2);
        return s1;
    };
    protected Path serviceRegistryDirectory;
    private Map<Long, RegisteredService> serviceMap = new ConcurrentHashMap<Long, RegisteredService>();
    private Collection<StringSerializer<RegisteredService>> registeredServiceSerializers;
    private PathWatcherService serviceRegistryConfigWatcher;
    private Pattern serviceFileNamePattern;
    private RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy;
    private RegisteredServiceResourceNamingStrategy resourceNamingStrategy;

    public AbstractResourceBasedServiceRegistry(Resource configDirectory, Collection<StringSerializer<RegisteredService>> serializers, ApplicationEventPublisher eventPublisher) throws Exception {
        this(configDirectory, serializers, false, eventPublisher, (RegisteredServiceReplicationStrategy)new NoOpRegisteredServiceReplicationStrategy(), (RegisteredServiceResourceNamingStrategy)new DefaultRegisteredServiceResourceNamingStrategy());
    }

    public AbstractResourceBasedServiceRegistry(Path configDirectory, StringSerializer<RegisteredService> serializer, boolean enableWatcher, ApplicationEventPublisher eventPublisher, RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy, RegisteredServiceResourceNamingStrategy resourceNamingStrategy) {
        this(configDirectory, (Collection<StringSerializer<RegisteredService>>)CollectionUtils.wrap(serializer), enableWatcher, eventPublisher, registeredServiceReplicationStrategy, resourceNamingStrategy);
    }

    public AbstractResourceBasedServiceRegistry(Path configDirectory, Collection<StringSerializer<RegisteredService>> serializers, boolean enableWatcher, ApplicationEventPublisher eventPublisher, RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy, RegisteredServiceResourceNamingStrategy resourceNamingStrategy) {
        this.initializeRegistry(configDirectory, serializers, enableWatcher, eventPublisher, registeredServiceReplicationStrategy, resourceNamingStrategy);
    }

    public AbstractResourceBasedServiceRegistry(Resource configDirectory, Collection<StringSerializer<RegisteredService>> serializers, boolean enableWatcher, ApplicationEventPublisher eventPublisher, RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy, RegisteredServiceResourceNamingStrategy resourceNamingStrategy) throws Exception {
        Resource servicesDirectory = ResourceUtils.prepareClasspathResourceIfNeeded((Resource)configDirectory, (boolean)true, (String)this.getExtension());
        if (servicesDirectory == null) {
            throw new IllegalArgumentException("Could not determine the services configuration directory from " + configDirectory);
        }
        File file = servicesDirectory.getFile();
        this.initializeRegistry(Paths.get(file.getCanonicalPath(), new String[0]), serializers, enableWatcher, eventPublisher, registeredServiceReplicationStrategy, resourceNamingStrategy);
    }

    private void initializeRegistry(Path configDirectory, Collection<StringSerializer<RegisteredService>> serializers, boolean enableWatcher, ApplicationEventPublisher eventPublisher, RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy, RegisteredServiceResourceNamingStrategy resourceNamingStrategy) {
        this.setEventPublisher(eventPublisher);
        this.registeredServiceReplicationStrategy = (RegisteredServiceReplicationStrategy)ObjectUtils.defaultIfNull((Object)registeredServiceReplicationStrategy, (Object)new NoOpRegisteredServiceReplicationStrategy());
        this.resourceNamingStrategy = (RegisteredServiceResourceNamingStrategy)ObjectUtils.defaultIfNull((Object)resourceNamingStrategy, (Object)new DefaultRegisteredServiceResourceNamingStrategy());
        this.registeredServiceSerializers = serializers;
        this.serviceFileNamePattern = RegexUtils.createPattern((String)(PATTERN_REGISTERED_SERVICE_FILE_NAME + this.getExtension()));
        this.serviceRegistryDirectory = configDirectory;
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().exists(), (String)(this.serviceRegistryDirectory + " does not exist"));
        Assert.isTrue((boolean)this.serviceRegistryDirectory.toFile().isDirectory(), (String)(this.serviceRegistryDirectory + " is not a directory"));
        if (enableWatcher) {
            this.enableServicesDirectoryPathWatcher();
        }
    }

    private void enableServicesDirectoryPathWatcher() {
        LOGGER.info("Watching service registry directory at [{}]", (Object)this.serviceRegistryDirectory);
        CreateResourceBasedRegisteredServiceWatcher onCreate = new CreateResourceBasedRegisteredServiceWatcher(this);
        DeleteResourceBasedRegisteredServiceWatcher onDelete = new DeleteResourceBasedRegisteredServiceWatcher(this);
        ModifyResourceBasedRegisteredServiceWatcher onModify = new ModifyResourceBasedRegisteredServiceWatcher(this);
        this.serviceRegistryConfigWatcher = new PathWatcherService(this.serviceRegistryDirectory, (Consumer)onCreate, (Consumer)onModify, (Consumer)onDelete);
        this.serviceRegistryConfigWatcher.start(this.getClass().getSimpleName());
        LOGGER.debug("Started service registry watcher thread");
    }

    @PreDestroy
    public void destroy() {
        if (this.serviceRegistryConfigWatcher != null) {
            this.serviceRegistryConfigWatcher.close();
        }
    }

    public long size() {
        return this.serviceMap.size();
    }

    public RegisteredService findServiceById(long id) {
        RegisteredService service = this.serviceMap.get(id);
        return this.registeredServiceReplicationStrategy.getRegisteredServiceFromCacheIfAny(service, id, (ServiceRegistry)this);
    }

    public RegisteredService findServiceById(String id) {
        RegisteredService service = this.serviceMap.values().stream().filter(r -> r.matches(id)).findFirst().orElse(null);
        return this.registeredServiceReplicationStrategy.getRegisteredServiceFromCacheIfAny(service, id, (ServiceRegistry)this);
    }

    public synchronized boolean delete(RegisteredService service) {
        boolean result;
        File f = this.getRegisteredServiceFileName(service);
        this.publishEvent((ApplicationEvent)new CasRegisteredServicePreDeleteEvent((Object)this, service));
        boolean bl = result = f.exists() ? f.delete() : true;
        if (!result) {
            LOGGER.warn("Failed to delete service definition file [{}]", (Object)f.getCanonicalPath());
        } else {
            this.removeRegisteredService(service);
            LOGGER.debug("Successfully deleted service definition file [{}]", (Object)f.getCanonicalPath());
        }
        this.publishEvent((ApplicationEvent)new CasRegisteredServiceDeletedEvent((Object)this, service));
        return result;
    }

    protected void removeRegisteredService(RegisteredService service) {
        this.serviceMap.remove(service.getId());
    }

    public synchronized List<RegisteredService> load() {
        Collection files = FileUtils.listFiles((File)this.serviceRegistryDirectory.toFile(), (String[])new String[]{this.getExtension()}, (boolean)true);
        this.serviceMap = files.stream().map(this::load).filter(Objects::nonNull).flatMap(Collection::stream).sorted().collect(Collectors.toMap(RegisteredService::getId, Function.identity(), LOG_DUPLICATE_AND_RETURN_FIRST_ONE, LinkedHashMap::new));
        ArrayList<RegisteredService> services = new ArrayList<RegisteredService>(this.serviceMap.values());
        List<RegisteredService> results = this.registeredServiceReplicationStrategy.updateLoadedRegisteredServicesFromCache(services, this);
        results.forEach(service -> this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, service)));
        return results;
    }

    public Collection<RegisteredService> load(File file) {
        Collection collection;
        String fileName = file.getName();
        if (!file.canRead()) {
            LOGGER.warn("[{}] is not readable. Check file permissions", (Object)fileName);
            return new ArrayList<RegisteredService>(0);
        }
        if (!file.exists()) {
            LOGGER.warn("[{}] is not found at the path specified", (Object)fileName);
            return new ArrayList<RegisteredService>(0);
        }
        if (file.length() == 0L) {
            LOGGER.debug("[{}] appears to be empty so no service definition will be loaded", (Object)fileName);
            return new ArrayList<RegisteredService>(0);
        }
        if (fileName.startsWith(".")) {
            LOGGER.debug("[{}] starts with ., ignoring", (Object)fileName);
            return new ArrayList<RegisteredService>(0);
        }
        if (!RegexUtils.matches((Pattern)this.serviceFileNamePattern, (String)fileName)) {
            LOGGER.warn("[{}] does not match the recommended pattern [{}]. While CAS tries to be forgiving as much as possible, it's recommended that you rename the file to match the requested pattern to avoid issues with duplicate service loading. Future CAS versions may try to strictly force the naming syntax, refusing to load the file.", (Object)fileName, (Object)this.serviceFileNamePattern.pattern());
        }
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        Throwable throwable = null;
        try {
            collection = this.registeredServiceSerializers.stream().filter(s -> s.supports(file)).map(s -> s.load((InputStream)in)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    AbstractResourceBasedServiceRegistry.$closeResource(throwable, in);
                    throw throwable3;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error reading configuration file [{}]", (Object)fileName, (Object)e);
                return new ArrayList<RegisteredService>(0);
            }
        }
        AbstractResourceBasedServiceRegistry.$closeResource(throwable, in);
        return collection;
    }

    public RegisteredService save(RegisteredService service) {
        if (service.getId() == -1L) {
            LOGGER.debug("Service id not set. Calculating id based on system time...");
            service.setId(System.currentTimeMillis());
        }
        File f = this.getRegisteredServiceFileName(service);
        try (OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            boolean result = this.registeredServiceSerializers.stream().anyMatch(s -> {
                try {
                    s.to(out, (Object)service);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    return false;
                }
            });
            if (!result) {
                throw new IOException("The service definition file could not be saved at " + f.getCanonicalPath());
            }
            if (this.serviceMap.containsKey(service.getId())) {
                LOGGER.debug("Found existing service definition by id [{}]. Saving...", (Object)service.getId());
            }
            this.serviceMap.put(service.getId(), service);
            LOGGER.debug("Saved service to [{}]", (Object)f.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO error opening file stream.", e);
        }
        return this.findServiceById(service.getId());
    }

    public void update(RegisteredService service) {
        this.serviceMap.put(service.getId(), service);
    }

    protected RegisteredService getRegisteredServiceFromFile(File file) {
        Matcher matcher = this.serviceFileNamePattern.matcher(file.getName());
        if (matcher.find()) {
            String serviceId = matcher.group(2);
            if (NumberUtils.isCreatable((String)serviceId)) {
                long id = Long.parseLong(serviceId);
                return this.findServiceById(id);
            }
            String serviceName = matcher.group(1);
            return this.findServiceByExactServiceName(serviceName);
        }
        LOGGER.warn("Provided file [{}} does not match the recommended service definition file pattern [{}]", (Object)file.getName(), (Object)this.serviceFileNamePattern.pattern());
        return null;
    }

    protected File getRegisteredServiceFileName(RegisteredService service) {
        String fileName = this.resourceNamingStrategy.build(service, this.getExtension());
        File svcFile = new File(this.serviceRegistryDirectory.toFile(), fileName);
        LOGGER.debug("Using [{}] as the service definition file", (Object)svcFile.getCanonicalPath());
        return svcFile;
    }

    protected abstract String getExtension();

    @Generated
    public String toString() {
        return "AbstractResourceBasedServiceRegistry(serviceRegistryDirectory=" + this.serviceRegistryDirectory + ", serviceMap=" + this.serviceMap + ", registeredServiceSerializers=" + this.registeredServiceSerializers + ", serviceRegistryConfigWatcher=" + this.serviceRegistryConfigWatcher + ", serviceFileNamePattern=" + this.serviceFileNamePattern + ", registeredServiceReplicationStrategy=" + this.registeredServiceReplicationStrategy + ", resourceNamingStrategy=" + this.resourceNamingStrategy + ")";
    }
}

