/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.ProxyGrantingTicketImpl;
import org.apereo.cas.ticket.ProxyTicketImpl;
import org.apereo.cas.ticket.ServiceTicketImpl;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.TransientSessionTicketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreTicketCatalogConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreTicketCatalogConfiguration.class);

    public final void configureTicketCatalog(TicketCatalog plan) {
        LOGGER.debug("Registering core CAS protocol ticket definitions...");
        this.buildAndRegisterProxyTicketDefinition(plan, this.buildTicketDefinition(plan, "PT", ProxyTicketImpl.class, Integer.MIN_VALUE));
        this.buildAndRegisterServiceTicketDefinition(plan, this.buildTicketDefinition(plan, "ST", ServiceTicketImpl.class, Integer.MIN_VALUE));
        this.buildAndRegisterProxyGrantingTicketDefinition(plan, this.buildTicketDefinition(plan, "PGT", ProxyGrantingTicketImpl.class, Integer.MAX_VALUE));
        this.buildAndRegisterTicketGrantingTicketDefinition(plan, this.buildTicketDefinition(plan, "TGT", TicketGrantingTicketImpl.class, Integer.MAX_VALUE));
        this.buildAndRegisterTransientSessionTicketDefinition(plan, this.buildTicketDefinition(plan, "TST", TransientSessionTicketImpl.class, Integer.MAX_VALUE));
    }

    protected void buildAndRegisterProxyGrantingTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterProxyTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterServiceTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterTicketGrantingTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterTransientSessionTicketDefinition(TicketCatalog plan, TicketDefinition metadata) {
        this.registerTicketDefinition(plan, metadata);
    }
}

