/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.PseudoPlatformTransactionManager;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.ticket.TicketGrantingTicketProperties;
import org.apereo.cas.configuration.model.core.ticket.registry.TicketRegistryProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.ticket.DefaultTicketCatalog;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.factory.DefaultProxyGrantingTicketFactory;
import org.apereo.cas.ticket.factory.DefaultProxyTicketFactory;
import org.apereo.cas.ticket.factory.DefaultServiceTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTicketGrantingTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTransientSessionTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.ticket.proxy.support.Cas10ProxyHandler;
import org.apereo.cas.ticket.proxy.support.Cas20ProxyHandler;
import org.apereo.cas.ticket.registry.CachingTicketRegistry;
import org.apereo.cas.ticket.registry.DefaultTicketRegistry;
import org.apereo.cas.ticket.registry.DefaultTicketRegistrySupport;
import org.apereo.cas.ticket.registry.NoOpLockingStrategy;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.apereo.cas.ticket.support.AlwaysExpiresExpirationPolicy;
import org.apereo.cas.ticket.support.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy;
import org.apereo.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.support.RememberMeDelegatingExpirationPolicy;
import org.apereo.cas.ticket.support.ThrottledUseAndTimeoutExpirationPolicy;
import org.apereo.cas.ticket.support.TicketGrantingTicketExpirationPolicy;
import org.apereo.cas.ticket.support.TimeoutExpirationPolicy;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.HostNameBasedUniqueTicketIdGenerator;
import org.apereo.cas.util.cipher.ProtocolTicketCipherExecutor;
import org.apereo.cas.util.http.HttpClient;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration(value="casCoreTicketsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@EnableAsync
@EnableTransactionManagement(proxyTargetClass=true)
@AutoConfigureAfter(value={CasCoreUtilConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class})
public class CasCoreTicketsConfiguration
implements TransactionManagementConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreTicketsConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Lazy
    @Autowired
    @Qualifier(value="uniqueIdGeneratorsMap")
    private Map<String, UniqueTicketIdGenerator> uniqueIdGeneratorsMap;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient")
    private ObjectProvider<HttpClient> httpClient;
    @Autowired
    @Qualifier(value="hostnameVerifier")
    private ObjectProvider<HostnameVerifier> hostnameVerifier;
    @Autowired
    @Qualifier(value="sslContext")
    private ObjectProvider<SSLContext> sslContext;

    @ConditionalOnMissingBean(name={"casClientTicketValidator"})
    @Bean
    public AbstractUrlBasedTicketValidator casClientTicketValidator() {
        Cas10TicketValidator validator;
        String prefix = StringUtils.defaultString((String)this.casProperties.getClient().getPrefix(), (String)this.casProperties.getServer().getPrefix());
        switch (this.casProperties.getClient().getValidatorType()) {
            case CAS10: {
                validator = new Cas10TicketValidator(prefix);
                break;
            }
            case CAS20: {
                validator = new Cas20ServiceTicketValidator(prefix);
                break;
            }
            default: {
                validator = new Cas30ServiceTicketValidator(prefix);
            }
        }
        HttpURLConnectionFactory factory = new HttpURLConnectionFactory(){
            private static final long serialVersionUID = 3692658214483917813L;

            public HttpURLConnection buildHttpURLConnection(URLConnection conn) {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
                    httpsConnection.setSSLSocketFactory(((SSLContext)CasCoreTicketsConfiguration.this.sslContext.getIfAvailable()).getSocketFactory());
                    httpsConnection.setHostnameVerifier((HostnameVerifier)CasCoreTicketsConfiguration.this.hostnameVerifier.getIfAvailable());
                }
                return (HttpURLConnection)conn;
            }
        };
        validator.setURLConnectionFactory(factory);
        return validator;
    }

    @ConditionalOnMissingBean(name={"defaultProxyGrantingTicketFactory"})
    @Bean
    public ProxyGrantingTicketFactory defaultProxyGrantingTicketFactory() {
        return new DefaultProxyGrantingTicketFactory(this.ticketGrantingTicketUniqueIdGenerator(), this.grantingTicketExpirationPolicy(), this.protocolTicketCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"defaultProxyTicketFactory"})
    @RefreshScope
    @Bean
    @Lazy
    public ProxyTicketFactory defaultProxyTicketFactory() {
        boolean onlyTrackMostRecentSession = this.casProperties.getTicket().getTgt().isOnlyTrackMostRecentSession();
        return new DefaultProxyTicketFactory(this.proxyTicketExpirationPolicy(), this.uniqueIdGeneratorsMap, this.protocolTicketCipherExecutor(), onlyTrackMostRecentSession);
    }

    @ConditionalOnMissingBean(name={"ticketGrantingTicketUniqueIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator ticketGrantingTicketUniqueIdGenerator() {
        return new HostNameBasedUniqueTicketIdGenerator.TicketGrantingTicketIdGenerator(this.casProperties.getTicket().getTgt().getMaxLength(), this.casProperties.getHost().getName());
    }

    @ConditionalOnMissingBean(name={"proxy20TicketUniqueIdGenerator"})
    @Bean
    public UniqueTicketIdGenerator proxy20TicketUniqueIdGenerator() {
        return new HostNameBasedUniqueTicketIdGenerator.ProxyTicketIdGenerator(this.casProperties.getTicket().getPgt().getMaxLength(), this.casProperties.getHost().getName());
    }

    @ConditionalOnMissingBean(name={"defaultTransientSessionTicketFactory"})
    @Bean
    public TransientSessionTicketFactory defaultTransientSessionTicketFactory() {
        return new DefaultTransientSessionTicketFactory(this.transientSessionTicketExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"transientSessionTicketExpirationPolicy"})
    @Bean
    public ExpirationPolicy transientSessionTicketExpirationPolicy() {
        return new HardTimeoutExpirationPolicy(this.casProperties.getTicket().getTst().getTimeToKillInSeconds());
    }

    @ConditionalOnMissingBean(name={"defaultServiceTicketFactory"})
    @Bean
    @Lazy
    public ServiceTicketFactory defaultServiceTicketFactory() {
        boolean onlyTrackMostRecentSession = this.casProperties.getTicket().getTgt().isOnlyTrackMostRecentSession();
        return new DefaultServiceTicketFactory(this.serviceTicketExpirationPolicy(), this.uniqueIdGeneratorsMap, onlyTrackMostRecentSession, this.protocolTicketCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"defaultTicketGrantingTicketFactory"})
    @Bean
    public TicketGrantingTicketFactory defaultTicketGrantingTicketFactory() {
        return new DefaultTicketGrantingTicketFactory(this.ticketGrantingTicketUniqueIdGenerator(), this.grantingTicketExpirationPolicy(), this.protocolTicketCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"defaultTicketFactory"})
    @Bean
    public TicketFactory defaultTicketFactory() {
        DefaultTicketFactory factory = new DefaultTicketFactory();
        factory.addTicketFactory(TransientSessionTicket.class, (TicketFactory)this.defaultTransientSessionTicketFactory()).addTicketFactory(ProxyGrantingTicket.class, (TicketFactory)this.defaultProxyGrantingTicketFactory()).addTicketFactory(TicketGrantingTicket.class, (TicketFactory)this.defaultTicketGrantingTicketFactory()).addTicketFactory(ServiceTicket.class, (TicketFactory)this.defaultServiceTicketFactory()).addTicketFactory(ProxyTicket.class, (TicketFactory)this.defaultProxyTicketFactory());
        return factory;
    }

    @ConditionalOnMissingBean(name={"proxy10Handler"})
    @Bean
    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    public ProxyHandler proxy10Handler() {
        return new Cas10ProxyHandler();
    }

    @ConditionalOnMissingBean(name={"proxy20Handler"})
    @Bean
    @ConditionalOnProperty(prefix="cas.sso", name={"proxyAuthnEnabled"}, havingValue="true", matchIfMissing=true)
    public ProxyHandler proxy20Handler() {
        return new Cas20ProxyHandler((HttpClient)this.httpClient.getIfAvailable(), this.proxy20TicketUniqueIdGenerator());
    }

    @ConditionalOnMissingBean(name={"ticketRegistry"})
    @Bean
    public TicketRegistry ticketRegistry() {
        LOGGER.warn("Runtime memory is used as the persistence storage for retrieving and managing tickets. Tickets that are issued during runtime will be LOST when the web server is restarted. This MAY impact SSO functionality.");
        TicketRegistryProperties.InMemory mem = this.casProperties.getTicket().getRegistry().getInMemory();
        CipherExecutor cipher = CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)mem.getCrypto(), (String)"inMemory");
        if (mem.isCache()) {
            LogoutManager logoutManager = (LogoutManager)this.applicationContext.getBean("logoutManager", LogoutManager.class);
            return new CachingTicketRegistry(cipher, logoutManager);
        }
        return new DefaultTicketRegistry(mem.getInitialCapacity(), mem.getLoadFactor(), mem.getConcurrency(), cipher);
    }

    @ConditionalOnMissingBean(name={"defaultTicketRegistrySupport"})
    @Bean
    public TicketRegistrySupport defaultTicketRegistrySupport() {
        return new DefaultTicketRegistrySupport(this.ticketRegistry);
    }

    @ConditionalOnMissingBean(name={"grantingTicketExpirationPolicy"})
    @Bean
    public ExpirationPolicy grantingTicketExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        if (tgt.getRememberMe().isEnabled()) {
            return this.rememberMeExpirationPolicy();
        }
        return this.ticketGrantingTicketExpirationPolicy();
    }

    @Bean
    public ExpirationPolicy rememberMeExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        HardTimeoutExpirationPolicy rememberMePolicy = new HardTimeoutExpirationPolicy(tgt.getRememberMe().getTimeToKillInSeconds());
        RememberMeDelegatingExpirationPolicy p = new RememberMeDelegatingExpirationPolicy(this.ticketGrantingTicketExpirationPolicy());
        p.addPolicy((Enum)RememberMeDelegatingExpirationPolicy.PolicyTypes.REMEMBER_ME, (ExpirationPolicy)rememberMePolicy);
        p.addPolicy((Enum)RememberMeDelegatingExpirationPolicy.PolicyTypes.DEFAULT, this.ticketGrantingTicketExpirationPolicy());
        return p;
    }

    @ConditionalOnMissingBean(name={"serviceTicketExpirationPolicy"})
    @Bean
    public ExpirationPolicy serviceTicketExpirationPolicy() {
        return new MultiTimeUseOrTimeoutExpirationPolicy.ServiceTicketExpirationPolicy(this.casProperties.getTicket().getSt().getNumberOfUses(), this.casProperties.getTicket().getSt().getTimeToKillInSeconds());
    }

    @ConditionalOnMissingBean(name={"proxyTicketExpirationPolicy"})
    @Bean
    public ExpirationPolicy proxyTicketExpirationPolicy() {
        return new MultiTimeUseOrTimeoutExpirationPolicy.ProxyTicketExpirationPolicy(this.casProperties.getTicket().getPt().getNumberOfUses(), (long)this.casProperties.getTicket().getPt().getTimeToKillInSeconds());
    }

    @ConditionalOnMissingBean(name={"lockingStrategy"})
    @Bean
    public LockingStrategy lockingStrategy() {
        return new NoOpLockingStrategy();
    }

    @ConditionalOnMissingBean(name={"ticketTransactionManager"})
    @Bean
    public PlatformTransactionManager ticketTransactionManager() {
        return new PseudoPlatformTransactionManager();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"protocolTicketCipherExecutor"})
    public CipherExecutor protocolTicketCipherExecutor() {
        EncryptionJwtSigningJwtCryptographyProperties crypto = this.casProperties.getTicket().getCrypto();
        if (crypto.isEnabled()) {
            return new ProtocolTicketCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg());
        }
        LOGGER.debug("Protocol tickets generated by CAS are not signed/encrypted.");
        return CipherExecutor.noOp();
    }

    @ConditionalOnMissingBean(name={"ticketGrantingTicketExpirationPolicy"})
    @Bean
    public ExpirationPolicy ticketGrantingTicketExpirationPolicy() {
        TicketGrantingTicketProperties tgt = this.casProperties.getTicket().getTgt();
        if (tgt.getMaxTimeToLiveInSeconds() <= 0 && tgt.getTimeToKillInSeconds() <= 0) {
            LOGGER.warn("Ticket-granting ticket expiration policy is set to NEVER expire tickets.");
            return new NeverExpiresExpirationPolicy();
        }
        if (tgt.getTimeout().getMaxTimeToLiveInSeconds() > 0) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on a timeout of [{}] seconds", (Object)tgt.getTimeout().getMaxTimeToLiveInSeconds());
            return new TimeoutExpirationPolicy((long)tgt.getTimeout().getMaxTimeToLiveInSeconds());
        }
        if (tgt.getThrottledTimeout().getTimeInBetweenUsesInSeconds() > 0L && tgt.getThrottledTimeout().getTimeToKillInSeconds() > 0L) {
            ThrottledUseAndTimeoutExpirationPolicy p = new ThrottledUseAndTimeoutExpirationPolicy();
            p.setTimeToKillInSeconds(tgt.getThrottledTimeout().getTimeToKillInSeconds());
            p.setTimeInBetweenUsesInSeconds(tgt.getThrottledTimeout().getTimeInBetweenUsesInSeconds());
            LOGGER.debug("Ticket-granting ticket expiration policy is based on throttled timeouts");
            return p;
        }
        if (tgt.getHardTimeout().getTimeToKillInSeconds() > 0L) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on a hard timeout of [{}] seconds", (Object)tgt.getHardTimeout().getTimeToKillInSeconds());
            return new HardTimeoutExpirationPolicy(tgt.getHardTimeout().getTimeToKillInSeconds());
        }
        if (tgt.getMaxTimeToLiveInSeconds() > 0 && tgt.getTimeToKillInSeconds() > 0) {
            LOGGER.debug("Ticket-granting ticket expiration policy is based on hard/idle timeouts of [{}]/[{}] seconds", (Object)tgt.getMaxTimeToLiveInSeconds(), (Object)tgt.getTimeToKillInSeconds());
            return new TicketGrantingTicketExpirationPolicy((long)tgt.getMaxTimeToLiveInSeconds(), (long)tgt.getTimeToKillInSeconds());
        }
        LOGGER.warn("Ticket-granting ticket expiration policy is set to ALWAYS expire tickets.");
        return new AlwaysExpiresExpirationPolicy();
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return this.ticketTransactionManager();
    }

    @ConditionalOnMissingBean(name={"ticketCatalog"})
    @Autowired
    @Bean
    public TicketCatalog ticketCatalog(List<TicketCatalogConfigurer> configurers) {
        DefaultTicketCatalog plan = new DefaultTicketCatalog();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring ticket metadata registration plan [{}]", (Object)name);
            c.configureTicketCatalog((TicketCatalog)plan);
        });
        return plan;
    }
}

