/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.ticket.registry.DefaultTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.NoOpTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="casCoreTicketsSchedulingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@EnableAsync
@EnableTransactionManagement(proxyTargetClass=true)
@AutoConfigureAfter(value={CasCoreTicketsConfiguration.class})
public class CasCoreTicketsSchedulingConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreTicketsSchedulingConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"ticketRegistryCleaner"})
    @Bean
    @Autowired
    public TicketRegistryCleaner ticketRegistryCleaner(@Qualifier(value="lockingStrategy") LockingStrategy lockingStrategy, @Qualifier(value="logoutManager") LogoutManager logoutManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        boolean isCleanerEnabled = this.casProperties.getTicket().getRegistry().getCleaner().getSchedule().isEnabled();
        if (isCleanerEnabled) {
            LOGGER.debug("Ticket registry cleaner is enabled.");
            return new DefaultTicketRegistryCleaner(lockingStrategy, logoutManager, ticketRegistry);
        }
        LOGGER.debug("Ticket registry cleaner is not enabled. Expired tickets are not forcefully collected and cleaned by CAS. It is up to the ticket registry itself to clean up tickets based on expiration and eviction policies.");
        return NoOpTicketRegistryCleaner.getInstance();
    }

    @ConditionalOnMissingBean(name={"ticketRegistryCleanerScheduler"})
    @ConditionalOnProperty(prefix="cas.ticket.registry.cleaner", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    @Autowired
    @RefreshScope
    public TicketRegistryCleanerScheduler ticketRegistryCleanerScheduler(@Qualifier(value="ticketRegistryCleaner") TicketRegistryCleaner ticketRegistryCleaner) {
        return new TicketRegistryCleanerScheduler(ticketRegistryCleaner);
    }

    public static class TicketRegistryCleanerScheduler {
        private final TicketRegistryCleaner ticketRegistryCleaner;

        public TicketRegistryCleanerScheduler(TicketRegistryCleaner ticketRegistryCleaner) {
            this.ticketRegistryCleaner = ticketRegistryCleaner;
        }

        @Scheduled(initialDelayString="${cas.ticket.registry.cleaner.schedule.startDelay:PT30S}", fixedDelayString="${cas.ticket.registry.cleaner.schedule.repeatInterval:PT120S}")
        public void run() {
            try {
                this.ticketRegistryCleaner.clean();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

