/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.DefaultServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.validation.RegisteredServiceRequiredHandlersServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(value="casCoreValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreValidationConfiguration
implements ServiceTicketValidationAuthorizerConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreValidationConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Bean
    @Scope(value="prototype")
    public CasProtocolValidationSpecification cas10ProtocolValidationSpecification() {
        return new Cas10ProtocolValidationSpecification();
    }

    @Bean
    @Scope(value="prototype")
    public CasProtocolValidationSpecification cas20ProtocolValidationSpecification() {
        return new Cas20ProtocolValidationSpecification();
    }

    @Bean
    @Scope(value="prototype")
    public CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification() {
        return new Cas20WithoutProxyingValidationSpecification();
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"serviceValidationAuthorizers"})
    public ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers(List<ServiceTicketValidationAuthorizerConfigurer> configurers) {
        DefaultServiceTicketValidationAuthorizersExecutionPlan plan = new DefaultServiceTicketValidationAuthorizersExecutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring service ticket validation authorizer execution plan [{}]", (Object)name);
            c.configureAuthorizersExecutionPlan((ServiceTicketValidationAuthorizersExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    public ServiceTicketValidationAuthorizer requiredHandlersServiceTicketValidationAuthorizer() {
        return new RegisteredServiceRequiredHandlersServiceTicketValidationAuthorizer(this.servicesManager);
    }

    public void configureAuthorizersExecutionPlan(ServiceTicketValidationAuthorizersExecutionPlan plan) {
        plan.registerAuthorizer(this.requiredHandlersServiceTicketValidationAuthorizer());
    }
}

