/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.apereo.cas.authentication.DefaultCasSslContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(value="casCoreHttpConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Order(value=-2147483648)
public class CasCoreHttpConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreHttpConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"trustStoreSslSocketFactory"})
    @Bean
    public SSLConnectionSocketFactory trustStoreSslSocketFactory() {
        return new SSLConnectionSocketFactory(this.sslContext(), this.hostnameVerifier());
    }

    @ConditionalOnMissingBean(name={"sslContext"})
    @Bean
    public SSLContext sslContext() {
        HttpClientProperties.Truststore client = this.casProperties.getHttpClient().getTruststore();
        if (client.getFile() != null && client.getFile().exists() && StringUtils.isNotBlank((CharSequence)client.getPsw())) {
            DefaultCasSslContext ctx = new DefaultCasSslContext(client.getFile(), client.getPsw(), KeyStore.getDefaultType());
            return ctx.getSslContext();
        }
        return SSLContexts.createSystemDefault();
    }

    @ConditionalOnMissingBean(name={"httpClient"})
    @Bean
    public FactoryBean<SimpleHttpClient> httpClient() {
        SimpleHttpClientFactoryBean.DefaultHttpClient c = new SimpleHttpClientFactoryBean.DefaultHttpClient();
        HttpClientProperties httpClient = this.casProperties.getHttpClient();
        c.setConnectionTimeout(Beans.newDuration((String)httpClient.getConnectionTimeout()).toMillis());
        c.setReadTimeout((int)Beans.newDuration((String)httpClient.getReadTimeout()).toMillis());
        return c;
    }

    @ConditionalOnMissingBean(name={"noRedirectHttpClient"})
    @Bean
    public HttpClient noRedirectHttpClient() throws Exception {
        return this.getHttpClient(false);
    }

    @ConditionalOnMissingBean(name={"supportsTrustStoreSslSocketFactoryHttpClient"})
    @Bean
    public HttpClient supportsTrustStoreSslSocketFactoryHttpClient() throws Exception {
        return this.getHttpClient(true);
    }

    @ConditionalOnMissingBean(name={"hostnameVerifier"})
    @Bean
    public HostnameVerifier hostnameVerifier() {
        if (this.casProperties.getHttpClient().getHostNameVerifier().equalsIgnoreCase("none")) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return new DefaultHostnameVerifier();
    }

    private HttpClient getHttpClient(boolean redirectEnabled) {
        SimpleHttpClientFactoryBean.DefaultHttpClient c = new SimpleHttpClientFactoryBean.DefaultHttpClient();
        HttpClientProperties httpClient = this.casProperties.getHttpClient();
        c.setConnectionTimeout(Beans.newDuration((String)httpClient.getConnectionTimeout()).toMillis());
        c.setReadTimeout((int)Beans.newDuration((String)httpClient.getReadTimeout()).toMillis());
        c.setRedirectsEnabled(redirectEnabled);
        c.setCircularRedirectsAllowed(redirectEnabled);
        c.setSslSocketFactory(this.trustStoreSslSocketFactory());
        c.setHostnameVerifier(this.hostnameVerifier());
        return c.getObject();
    }
}

