/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.extractcert;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.web.extractcert.X509CertificateExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderX509CertificateExtractor
implements X509CertificateExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHeaderX509CertificateExtractor.class);
    private static final String X509_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String X509_FOOTER = "-----END CERTIFICATE-----";
    private final String sslClientCertHeader;

    private String getCertFromHeader(HttpServletRequest request) {
        String certHeaderValue = request.getHeader(this.sslClientCertHeader);
        if (StringUtils.isBlank((CharSequence)certHeaderValue)) {
            return null;
        }
        if ("(null)".equalsIgnoreCase(certHeaderValue)) {
            return null;
        }
        return StringUtils.trim((String)certHeaderValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate[] extract(HttpServletRequest request) {
        String certHeaderValue = this.getCertFromHeader(request);
        if (StringUtils.isBlank((CharSequence)certHeaderValue)) {
            LOGGER.debug("No header [{}] found in request (or value was null)", (Object)this.sslClientCertHeader);
            return null;
        }
        if (certHeaderValue.length() < X509_HEADER.length()) {
            LOGGER.debug("Header [{}] found but it is too short to parse. Header value: [{}]", (Object)this.sslClientCertHeader, (Object)certHeaderValue);
            return null;
        }
        String body = this.sanitizeCertificateBody(certHeaderValue);
        try (ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes(StandardCharsets.ISO_8859_1));){
            X509Certificate cert = CertUtils.readCertificate((InputStream)input);
            LOGGER.debug("Certificate extracted from header [{}] with subject: [{}]", (Object)this.sslClientCertHeader, (Object)cert.getSubjectDN());
            X509Certificate[] x509CertificateArray = new X509Certificate[]{cert};
            return x509CertificateArray;
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing the certificate in header: [{}] value: [{}] with error msg: [{}]", new Object[]{this.sslClientCertHeader, body, e.getMessage()});
            LOGGER.debug("Error parsing the certificate in header: [{}] value: [{}]", new Object[]{this.sslClientCertHeader, body, e});
            return null;
        }
    }

    private String sanitizeCertificateBody(String certHeaderValue) {
        String body = certHeaderValue.substring(X509_HEADER.length(), certHeaderValue.length() - X509_FOOTER.length());
        body = body.replace(' ', '\n');
        body = body.replace('\t', '\n');
        return X509_HEADER.concat("\n").concat(body).concat("\n").concat(X509_FOOTER).concat("\n");
    }

    @Generated
    public String getSslClientCertHeader() {
        return this.sslClientCertHeader;
    }

    @Generated
    public RequestHeaderX509CertificateExtractor(String sslClientCertHeader) {
        this.sslClientCertHeader = sslClientCertHeader;
    }
}

