/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.LogoutRequest;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public final class WebUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebUtils.class);
    public static final String CAS_ACCESS_DENIED_REASON = "CAS_ACCESS_DENIED_REASON";
    public static final String PARAMETER_TICKET_GRANTING_TICKET_ID = "ticketGrantingTicketId";
    private static final String PUBLIC_WORKSTATION_ATTRIBUTE = "publicWorkstation";
    private static final String PARAMETER_AUTHENTICATION = "authentication";
    private static final String PARAMETER_AUTHENTICATION_RESULT_BUILDER = "authenticationResultBuilder";
    private static final String PARAMETER_AUTHENTICATION_RESULT = "authenticationResult";
    private static final String PARAMETER_CREDENTIAL = "credential";
    private static final String PARAMETER_UNAUTHORIZED_REDIRECT_URL = "unauthorizedRedirectUrl";
    private static final String PARAMETER_REGISTERED_SERVICE = "registeredService";
    private static final String PARAMETER_SERVICE = "service";
    private static final String PARAMETER_SERVICE_TICKET_ID = "serviceTicketId";
    private static final String PARAMETER_LOGOUT_REQUESTS = "logoutRequests";
    private static final String PARAMETER_SERVICE_UI_METADATA = "serviceUIMetadata";

    public static HttpServletRequest getHttpServletRequestFromExternalWebflowContext(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletRequest)context.getExternalContext().getNativeRequest();
    }

    public static HttpServletRequest getHttpServletRequestFromExternalWebflowContext() {
        ServletExternalContext servletExternalContext = (ServletExternalContext)ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletRequest)servletExternalContext.getNativeRequest();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponseFromExternalWebflowContext(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName()));
        return (HttpServletResponse)context.getExternalContext().getNativeResponse();
    }

    public static HttpServletResponse getHttpServletResponseFromExternalWebflowContext() {
        ServletExternalContext servletExternalContext = (ServletExternalContext)ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletResponse)servletExternalContext.getNativeResponse();
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return HttpRequestUtils.getService(argumentExtractors, (HttpServletRequest)request);
    }

    public static WebApplicationService getService(RequestContext context) {
        return context != null ? (WebApplicationService)context.getFlowScope().get(PARAMETER_SERVICE) : null;
    }

    public static RegisteredService getRegisteredService(RequestContext context) {
        return context != null ? (RegisteredService)context.getFlowScope().get(PARAMETER_REGISTERED_SERVICE) : null;
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, TicketGrantingTicket ticket) {
        String ticketValue = ticket != null ? ticket.getId() : null;
        WebUtils.putTicketGrantingTicketInScopes(context, ticketValue);
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, String ticketValue) {
        WebUtils.putTicketGrantingTicketIntoMap(context.getRequestScope(), ticketValue);
        WebUtils.putTicketGrantingTicketIntoMap(context.getFlowScope(), ticketValue);
        for (FlowSession session = context.getFlowExecutionContext().getActiveSession().getParent(); session != null; session = session.getParent()) {
            WebUtils.putTicketGrantingTicketIntoMap(session.getScope(), ticketValue);
        }
    }

    public static void putTicketGrantingTicketIntoMap(MutableAttributeMap map, String ticketValue) {
        map.put(PARAMETER_TICKET_GRANTING_TICKET_ID, (Object)ticketValue);
    }

    public static String getTicketGrantingTicketId(RequestContext context) {
        String tgtFromRequest = WebUtils.getTicketGrantingTicketIdFrom(context.getRequestScope());
        String tgtFromFlow = WebUtils.getTicketGrantingTicketIdFrom(context.getFlowScope());
        return tgtFromRequest != null ? tgtFromRequest : tgtFromFlow;
    }

    public static String getTicketGrantingTicketIdFrom(MutableAttributeMap scopeMap) {
        return (String)scopeMap.get(PARAMETER_TICKET_GRANTING_TICKET_ID);
    }

    public static void putServiceTicketInRequestScope(RequestContext context, ServiceTicket ticketValue) {
        context.getRequestScope().put(PARAMETER_SERVICE_TICKET_ID, (Object)ticketValue.getId());
    }

    public static String getServiceTicketFromRequestScope(RequestContext context) {
        return context.getRequestScope().getString(PARAMETER_SERVICE_TICKET_ID);
    }

    public static void putUnauthorizedRedirectUrlIntoFlowScope(RequestContext context, URI url) {
        context.getFlowScope().put(PARAMETER_UNAUTHORIZED_REDIRECT_URL, (Object)url);
    }

    public static URI getUnauthorizedRedirectUrlIntoFlowScope(RequestContext context) {
        return (URI)context.getFlowScope().get(PARAMETER_UNAUTHORIZED_REDIRECT_URL, URI.class);
    }

    public static void putLogoutRequests(RequestContext context, List<LogoutRequest> requests) {
        context.getFlowScope().put(PARAMETER_LOGOUT_REQUESTS, requests);
    }

    public static List<LogoutRequest> getLogoutRequests(RequestContext context) {
        return (List)context.getFlowScope().get(PARAMETER_LOGOUT_REQUESTS);
    }

    public static void putService(RequestContext context, Service service) {
        context.getFlowScope().put(PARAMETER_SERVICE, (Object)service);
    }

    public static void putWarningCookie(RequestContext context, Boolean cookieValue) {
        context.getFlowScope().put("warnCookieValue", (Object)cookieValue);
    }

    public static boolean getWarningCookie(RequestContext context) {
        String val = ObjectUtils.defaultIfNull((Object)context.getFlowScope().get("warnCookieValue"), (Object)Boolean.FALSE.toString()).toString();
        return Boolean.parseBoolean(val);
    }

    public static void putRegisteredService(RequestContext context, RegisteredService registeredService) {
        context.getFlowScope().put(PARAMETER_REGISTERED_SERVICE, (Object)registeredService);
    }

    public static <T extends Credential> T getCredential(RequestContext context, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        Credential credential = WebUtils.getCredential(context);
        if (credential == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(credential.getClass())) {
            throw new ClassCastException("credential [" + credential.getId() + " is of type " + credential.getClass() + " when we were expecting " + clazz);
        }
        return (T)credential;
    }

    public static Credential getCredential(RequestContext context) {
        Credential cFromRequest = (Credential)context.getRequestScope().get(PARAMETER_CREDENTIAL);
        Credential cFromFlow = (Credential)context.getFlowScope().get(PARAMETER_CREDENTIAL);
        Credential cFromConversation = (Credential)context.getConversationScope().get(PARAMETER_CREDENTIAL);
        Credential credential = cFromRequest;
        if (credential == null || StringUtils.isBlank((CharSequence)credential.getId())) {
            credential = cFromFlow;
        }
        if ((credential == null || StringUtils.isBlank((CharSequence)credential.getId())) && (credential = cFromConversation) != null && !StringUtils.isBlank((CharSequence)credential.getId())) {
            context.getFlowScope().put(PARAMETER_CREDENTIAL, (Object)credential);
        }
        if (credential == null) {
            FlowSession session = context.getFlowExecutionContext().getActiveSession();
            credential = (Credential)session.getScope().get(PARAMETER_CREDENTIAL, Credential.class);
        }
        if (credential != null && StringUtils.isBlank((CharSequence)credential.getId())) {
            return null;
        }
        return credential;
    }

    public static void putCredential(RequestContext context, Credential c) {
        if (c == null) {
            context.getRequestScope().remove(PARAMETER_CREDENTIAL);
            context.getFlowScope().remove(PARAMETER_CREDENTIAL);
            context.getConversationScope().remove(PARAMETER_CREDENTIAL);
        } else {
            context.getRequestScope().put(PARAMETER_CREDENTIAL, (Object)c);
            context.getFlowScope().put(PARAMETER_CREDENTIAL, (Object)c);
            context.getConversationScope().put(PARAMETER_CREDENTIAL, (Object)c);
        }
    }

    public static boolean isAuthenticatingAtPublicWorkstation(RequestContext ctx) {
        if (ctx.getFlowScope().contains(PUBLIC_WORKSTATION_ATTRIBUTE)) {
            LOGGER.debug("Public workstation flag detected. SSO session will be considered renewed.");
            return true;
        }
        return false;
    }

    public static void putPublicWorkstationToFlowIfRequestParameterPresent(RequestContext context) {
        if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get(PUBLIC_WORKSTATION_ATTRIBUTE))) {
            context.getFlowScope().put(PUBLIC_WORKSTATION_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    public static void putWarnCookieIfRequestParameterPresent(CookieGenerator warnCookieGenerator, RequestContext context) {
        if (warnCookieGenerator != null) {
            LOGGER.trace("Evaluating request to determine if warning cookie should be generated");
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext(context);
            if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get("warn"))) {
                warnCookieGenerator.addCookie(response, "true");
            }
        } else {
            LOGGER.trace("No warning cookie generator is defined");
        }
    }

    public static void putAuthentication(Authentication authentication, RequestContext ctx) {
        ctx.getConversationScope().put(PARAMETER_AUTHENTICATION, (Object)authentication);
    }

    public static Authentication getAuthentication(RequestContext ctx) {
        return (Authentication)ctx.getConversationScope().get(PARAMETER_AUTHENTICATION, Authentication.class);
    }

    public static void putAuthenticationResultBuilder(AuthenticationResultBuilder builder, RequestContext ctx) {
        ctx.getConversationScope().put(PARAMETER_AUTHENTICATION_RESULT_BUILDER, (Object)builder);
    }

    public static Principal getPrincipalFromRequestContext(RequestContext requestContext, TicketRegistrySupport ticketRegistrySupport) {
        String tgt = WebUtils.getTicketGrantingTicketId(requestContext);
        if (StringUtils.isBlank((CharSequence)tgt)) {
            throw new IllegalArgumentException("No ticket-granting ticket could be found in the context");
        }
        return ticketRegistrySupport.getAuthenticatedPrincipalFrom(tgt);
    }

    public static AuthenticationResultBuilder getAuthenticationResultBuilder(RequestContext ctx) {
        return (AuthenticationResultBuilder)ctx.getConversationScope().get(PARAMETER_AUTHENTICATION_RESULT_BUILDER, AuthenticationResultBuilder.class);
    }

    public static void putAuthenticationResult(AuthenticationResult authenticationResult, RequestContext context) {
        context.getConversationScope().put(PARAMETER_AUTHENTICATION_RESULT, (Object)authenticationResult);
    }

    public static AuthenticationResult getAuthenticationResult(RequestContext ctx) {
        return (AuthenticationResult)ctx.getConversationScope().get(PARAMETER_AUTHENTICATION_RESULT, AuthenticationResult.class);
    }

    public static String getHttpServletRequestUserAgentFromRequestContext() {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        return HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
    }

    public static String getHttpServletRequestUserAgentFromRequestContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
    }

    public static String getHttpServletRequestAcceptLanguageFromRequestContext() {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        return HttpRequestUtils.getHttpServletRequestAcceptLanguage((HttpServletRequest)request);
    }

    public static String getHttpServletRequestAcceptLanguageFromRequestContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return HttpRequestUtils.getHttpServletRequestAcceptLanguage((HttpServletRequest)request);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocationFromRequestContext() {
        HttpServletRequest servletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        return WebUtils.getHttpServletRequestGeoLocation(servletRequest);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocationFromRequestContext(RequestContext context) {
        HttpServletRequest servletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return WebUtils.getHttpServletRequestGeoLocation(servletRequest);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocation(HttpServletRequest servletRequest) {
        if (servletRequest != null) {
            return HttpRequestUtils.getHttpServletRequestGeoLocation((HttpServletRequest)servletRequest);
        }
        return null;
    }

    public static void putGeoLocationTrackingIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("trackGeoLocation", value);
    }

    public static void putRecaptchaSiteKeyIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("recaptchaSiteKey", value);
    }

    public static void putRecaptchaInvisibleIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("recaptchaInvisible", value);
    }

    public static void putRecaptchaPositionIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("recaptchaPosition", value);
    }

    public static void putStaticAuthenticationIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("staticAuthentication", value);
    }

    public static void putPasswordManagementEnabled(RequestContext context, Boolean value) {
        context.getFlowScope().put("passwordManagementEnabled", (Object)value);
    }

    public static void putGoogleAnalyticsTrackingIdIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("googleAnalyticsTrackingId", value);
    }

    public static void putUnauthorizedRedirectUrl(RequestContext context, URI unauthorizedRedirectUrl) {
        context.getFlowScope().put(PARAMETER_UNAUTHORIZED_REDIRECT_URL, (Object)unauthorizedRedirectUrl);
    }

    public static void putPrincipal(RequestContext requestContext, Principal authenticationPrincipal) {
        requestContext.getFlowScope().put("principal", (Object)authenticationPrincipal);
    }

    public static void putLogoutRedirectUrl(RequestContext context, String service) {
        context.getFlowScope().put("logoutRedirectUrl", (Object)service);
    }

    public static void putRememberMeAuthenticationEnabled(RequestContext context, Boolean enabled) {
        context.getFlowScope().put("rememberMeAuthenticationEnabled", (Object)enabled);
    }

    public static void putAttributeConsentEnabled(RequestContext context, Boolean enabled) {
        context.getFlowScope().put("attributeConsentEnabled", (Object)enabled);
    }

    public static Boolean isRememberMeAuthenticationEnabled(RequestContext context) {
        return context.getFlowScope().getBoolean("rememberMeAuthenticationEnabled", Boolean.FALSE);
    }

    public static void putResolvedMultifactorAuthenticationProviders(RequestContext context, Collection<MultifactorAuthenticationProvider> value) {
        Collection providerIds = value.stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
        context.getConversationScope().put("resolvedMultifactorAuthenticationProviders", (Object)providerIds);
    }

    public static Collection<String> getResolvedMultifactorAuthenticationProviders(RequestContext context) {
        return (Collection)context.getConversationScope().get("resolvedMultifactorAuthenticationProviders", Collection.class);
    }

    public static void putServiceUserInterfaceMetadata(RequestContext requestContext, Serializable mdui) {
        if (mdui != null) {
            requestContext.getFlowScope().put(PARAMETER_SERVICE_UI_METADATA, (Object)mdui);
        }
    }

    public static <T> T getServiceUserInterfaceMetadata(RequestContext requestContext, Class<T> clz) {
        if (requestContext.getFlowScope().contains(PARAMETER_SERVICE_UI_METADATA)) {
            return (T)requestContext.getFlowScope().get(PARAMETER_SERVICE_UI_METADATA, clz);
        }
        return null;
    }

    public static void putServiceRedirectUrl(RequestContext requestContext, String url) {
        requestContext.getRequestScope().put("url", (Object)url);
    }

    public static void putServiceResponseIntoRequestScope(RequestContext requestContext, Response response) {
        requestContext.getRequestScope().put("parameters", (Object)response.getAttributes());
        WebUtils.putServiceRedirectUrl(requestContext, response.getUrl());
    }

    public static void putServiceOriginalUrlIntoRequestScope(RequestContext requestContext, WebApplicationService service) {
        requestContext.getRequestScope().put("originalUrl", (Object)service.getOriginalUrl());
    }

    public static ModelAndView produceUnauthorizedErrorView() {
        return WebUtils.produceErrorView((Exception)new UnauthorizedServiceException("screen.service.error.message", ""));
    }

    public static ModelAndView produceErrorView(Exception e) {
        HashMap<String, Exception> model = new HashMap<String, Exception>();
        model.put("rootCauseException", e);
        return new ModelAndView("casServiceErrorView", model);
    }

    public static Authentication getInProgressAuthentication() {
        Authentication authentication = null;
        RequestContext context = RequestContextHolder.getRequestContext();
        if (context != null) {
            authentication = WebUtils.getAuthentication(context);
        }
        if (authentication == null) {
            authentication = AuthenticationCredentialsThreadLocalBinder.getInProgressAuthentication();
        }
        return authentication;
    }

    public static void putPasswordlessAuthenticationEnabled(RequestContext requestContext, Boolean value) {
        requestContext.getFlowScope().put("passwordlessAuthenticationEnabled", (Object)value);
    }

    public static void putPasswordlessAuthenticationAccount(RequestContext requestContext, Object account) {
        requestContext.getFlowScope().put("passwordlessAccount", account);
    }

    public static <T> T getPasswordlessAuthenticationAccount(Event event, Class<T> clazz) {
        return (T)event.getAttributes().get("passwordlessAccount", clazz);
    }

    public static <T> T getPasswordlessAuthenticationAccount(RequestContext event, Class<T> clazz) {
        return WebUtils.getPasswordlessAuthenticationAccount(event.getCurrentEvent(), clazz);
    }

    public static boolean hasPasswordlessAuthenticationAccount(RequestContext requestContext) {
        return requestContext.getFlowScope().contains("passwordlessAccount");
    }

    public static void putRequestSurrogateAuthentication(RequestContext context, Boolean value) {
        context.getFlowScope().put("requestSurrogateAccount", (Object)value);
    }

    public static boolean hasRequestSurrogateAuthenticationRequest(RequestContext requestContext) {
        return requestContext.getFlowScope().getBoolean("requestSurrogateAccount", Boolean.FALSE);
    }

    public static void removeRequestSurrogateAuthenticationRequest(RequestContext requestContext) {
        requestContext.getFlowScope().remove("requestSurrogateAccount");
    }

    public static void putSurrogateAuthenticationAccounts(RequestContext requestContext, List<String> surrogates) {
        requestContext.getFlowScope().put("surrogates", surrogates);
    }

    public static List<String> getSurrogateAuthenticationAccounts(RequestContext requestContext) {
        return (List)requestContext.getFlowScope().get("surrogates", List.class);
    }

    public static void putGraphicalUserAuthenticationEnabled(RequestContext requestContext, Boolean value) {
        requestContext.getFlowScope().put("guaEnabled", (Object)value);
    }

    public static void putGraphicalUserAuthenticationUsername(RequestContext requestContext, String username) {
        requestContext.getFlowScope().put("guaUsername", (Object)username);
    }

    public static boolean containsGraphicalUserAuthenticationUsername(RequestContext requestContext) {
        return requestContext.getFlowScope().contains("guaUsername");
    }

    public static void putGraphicalUserAuthenticationImage(RequestContext requestContext, String image) {
        requestContext.getFlowScope().put("guaUserImage", (Object)image);
    }

    public static boolean containsGraphicalUserAuthenticationImage(RequestContext requestContext) {
        return requestContext.getFlowScope().contains("guaUserImage");
    }

    @Generated
    private WebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

