/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.apereo.cas.web.report.util.ControllerUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public class LoggingConfigController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConfigController.class);
    private static final String VIEW_CONFIG = "monitoring/viewLoggingConfig";
    private static final String LOGGER_NAME_ROOT = "root";
    private static final String FILE_PARAM = "file";
    private static final String FILE_PATTERN_PARAM = "filePattern";
    @NonNull
    private LoggerContext loggerContext;
    private final AuditTrailExecutionPlan auditTrailManager;
    @Autowired
    private Environment environment;
    @Autowired
    private ResourceLoader resourceLoader;
    private Resource logConfigurationFile;

    public LoggingConfigController(AuditTrailExecutionPlan auditTrailManager, CasConfigurationProperties casProperties) {
        super("casloggingconfig", "/logging", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getLoggingConfig(), casProperties);
        this.auditTrailManager = auditTrailManager;
    }

    @PostConstruct
    public void initialize() {
        Optional<Pair<Resource, LoggerContext>> pair = ControllerUtils.buildLoggerContext(this.environment, this.resourceLoader);
        pair.ifPresent(it -> {
            this.logConfigurationFile = (Resource)it.getKey();
            this.loggerContext = (LoggerContext)it.getValue();
        });
    }

    @GetMapping
    public ModelAndView getDefaultView(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("logConfigurationFile", this.logConfigurationFile.getURI().toString());
        return new ModelAndView(VIEW_CONFIG, model);
    }

    @GetMapping(value={"/getActiveLoggers"})
    @ResponseBody
    public Map<String, Object> getActiveLoggers(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        Map<String, Logger> loggers = this.getActiveLoggersInFactory();
        responseMap.put("activeLoggers", loggers.values());
        return responseMap;
    }

    @GetMapping(value={"/getConfiguration"})
    @ResponseBody
    public Map<String, Object> getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashSet configuredLoggers = new HashSet();
        this.getLoggerConfigurations().forEach(config -> {
            HashMap<String, Object> loggerMap = new HashMap<String, Object>();
            loggerMap.put("name", StringUtils.defaultIfBlank((CharSequence)config.getName(), (CharSequence)LOGGER_NAME_ROOT));
            loggerMap.put("state", config.getState());
            if (config.getProperties() != null) {
                loggerMap.put("properties", config.getProperties());
            }
            loggerMap.put("additive", config.isAdditive());
            loggerMap.put("level", config.getLevel().name());
            HashSet appenders = new HashSet();
            config.getAppenders().keySet().stream().map(key -> (Appender)config.getAppenders().get(key)).forEach(appender -> {
                ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
                builder.append("name", (Object)appender.getName());
                builder.append("state", (Object)appender.getState());
                builder.append("layoutFormat", (Object)appender.getLayout().getContentFormat());
                builder.append("layoutContentType", (Object)appender.getLayout().getContentType());
                if (appender instanceof FileAppender) {
                    builder.append(FILE_PARAM, (Object)((FileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RandomAccessFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RandomAccessFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RollingFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)((RollingFileAppender)appender).getFilePattern());
                }
                if (appender instanceof MemoryMappedFileAppender) {
                    builder.append(FILE_PARAM, (Object)((MemoryMappedFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)"(none)");
                }
                if (appender instanceof RollingRandomAccessFileAppender) {
                    builder.append(FILE_PARAM, (Object)((RollingRandomAccessFileAppender)appender).getFileName());
                    builder.append(FILE_PATTERN_PARAM, (Object)((RollingRandomAccessFileAppender)appender).getFilePattern());
                }
                appenders.add(builder.build());
            });
            loggerMap.put("appenders", appenders);
            configuredLoggers.add(loggerMap);
        });
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("loggers", configuredLoggers);
        return responseMap;
    }

    private Map<String, Logger> getActiveLoggersInFactory() {
        Log4jLoggerFactory factory = (Log4jLoggerFactory)LoggingConfigController.getCasLoggerFactoryInstance();
        if (factory != null) {
            return factory.getLoggersInContext((org.apache.logging.log4j.spi.LoggerContext)this.loggerContext);
        }
        return new HashMap<String, Logger>(0);
    }

    private static ILoggerFactory getCasLoggerFactoryInstance() {
        return LoggerFactory.getILoggerFactory();
    }

    private Set<LoggerConfig> getLoggerConfigurations() {
        Configuration configuration = this.loggerContext.getConfiguration();
        return new HashSet<LoggerConfig>(configuration.getLoggers().values());
    }

    @PostMapping(value={"/updateLoggerLevel"})
    @ResponseBody
    public void updateLoggerLevel(@RequestParam String loggerName, @RequestParam String loggerLevel, @RequestParam(defaultValue="false") boolean additive, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        Set<LoggerConfig> loggerConfigs = this.getLoggerConfigurations();
        loggerConfigs.stream().filter(cfg -> cfg.getName().equals(loggerName)).forEachOrdered(cfg -> {
            cfg.setLevel(Level.getLevel((String)loggerLevel));
            cfg.setAdditive(additive);
        });
        this.loggerContext.updateLoggers();
    }

    @GetMapping(value={"/getAuditLog"})
    @ResponseBody
    public Set<AuditActionContext> getAuditLog(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        LocalDate sinceDate = LocalDate.now().minusDays(this.casProperties.getAudit().getNumberOfDaysInHistory());
        return this.auditTrailManager.getAuditRecordsSince(sinceDate);
    }
}

