/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class SingleSignOnSessionStatusController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionStatusController.class);
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final TicketRegistrySupport ticketRegistrySupport;

    public SingleSignOnSessionStatusController(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, TicketRegistrySupport ticketRegistrySupport, CasConfigurationProperties casProperties) {
        super("ssostatus", "/sso", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getSingleSignOnStatus(), casProperties);
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    @GetMapping(produces={"text/plain"})
    @ResponseBody
    public String getStatus(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        response.setStatus(HttpStatus.OK.value());
        String tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return SingleSignOnSessionStatusController.result(false);
        }
        Authentication auth = this.ticketRegistrySupport.getAuthenticationFrom(tgtId);
        return SingleSignOnSessionStatusController.result(auth != null);
    }

    private static String result(boolean res) {
        return BooleanUtils.toStringYesNo((boolean)res);
    }
}

