/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ISOStandardDateFormat;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.servlet.ModelAndView;

public class SingleSignOnSessionsReportController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsReportController.class);
    private static final String VIEW_SSO_SESSIONS = "monitoring/viewSsoSessions";
    private static final String STATUS = "status";
    private static final String TICKET_GRANTING_TICKET = "ticketGrantingTicket";
    private final CentralAuthenticationService centralAuthenticationService;

    public SingleSignOnSessionsReportController(CentralAuthenticationService centralAuthenticationService, CasConfigurationProperties casProperties) {
        super("ssosessions", "/ssosessions", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getSingleSignOnReport(), casProperties);
        this.centralAuthenticationService = centralAuthenticationService;
    }

    private Collection<Map<String, Object>> getActiveSsoSessions(SsoSessionReportOptions option) {
        ArrayList<Map<String, Object>> activeSessions = new ArrayList<Map<String, Object>>();
        ISOStandardDateFormat dateFormat = new ISOStandardDateFormat();
        this.getNonExpiredTicketGrantingTickets().stream().map(TicketGrantingTicket.class::cast).filter(tgt -> option != SsoSessionReportOptions.DIRECT || tgt.getProxiedBy() == null).forEach(tgt -> {
            Authentication authentication = tgt.getAuthentication();
            Principal principal = authentication.getPrincipal();
            HashMap<String, Object> sso = new HashMap<String, Object>(SsoSessionAttributeKeys.values().length);
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey(), principal.getId());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.getAttributeKey(), authentication.getAuthenticationDate());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE_FORMATTED.getAttributeKey(), dateFormat.format(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())));
            sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.getAttributeKey(), tgt.getCountOfUses());
            sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.getAttributeKey(), tgt.getId());
            sso.put(SsoSessionAttributeKeys.PRINCIPAL_ATTRIBUTES.getAttributeKey(), principal.getAttributes());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_ATTRIBUTES.getAttributeKey(), authentication.getAttributes());
            if (option != SsoSessionReportOptions.DIRECT) {
                if (tgt.getProxiedBy() != null) {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.TRUE);
                    sso.put(SsoSessionAttributeKeys.PROXIED_BY.getAttributeKey(), tgt.getProxiedBy().getId());
                } else {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.FALSE);
                }
            }
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_SERVICES.getAttributeKey(), tgt.getServices());
            activeSessions.add(sso);
        });
        return activeSessions;
    }

    private Collection<Ticket> getNonExpiredTicketGrantingTickets() {
        return this.centralAuthenticationService.getTickets(ticket -> ticket instanceof TicketGrantingTicket && !ticket.isExpired());
    }

    @GetMapping(value={"/getSsoSessions"})
    @ResponseBody
    public WebAsyncTask<Map<String, Object>> getSsoSessions(@RequestParam(defaultValue="ALL") String type, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        Callable<Map> asyncTask = () -> {
            HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
            SsoSessionReportOptions option = SsoSessionReportOptions.valueOf(type);
            Collection<Map<String, Object>> activeSsoSessions = this.getActiveSsoSessions(option);
            sessionsMap.put("activeSsoSessions", activeSsoSessions);
            long totalTicketGrantingTickets = 0L;
            long totalProxyGrantingTickets = 0L;
            long totalUsageCount = 0L;
            HashSet<String> uniquePrincipals = new HashSet<String>();
            for (Map<String, Object> activeSsoSession : activeSsoSessions) {
                if (activeSsoSession.containsKey(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey())) {
                    Boolean isProxied = Boolean.valueOf(activeSsoSession.get(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey()).toString());
                    if (isProxied.booleanValue()) {
                        ++totalProxyGrantingTickets;
                    } else {
                        ++totalTicketGrantingTickets;
                        String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey()).toString();
                        uniquePrincipals.add(principal);
                    }
                } else {
                    ++totalTicketGrantingTickets;
                    String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey()).toString();
                    uniquePrincipals.add(principal);
                }
                totalUsageCount += Long.parseLong(activeSsoSession.get(SsoSessionAttributeKeys.NUMBER_OF_USES.getAttributeKey()).toString());
            }
            sessionsMap.put("totalProxyGrantingTickets", totalProxyGrantingTickets);
            sessionsMap.put("totalTicketGrantingTickets", totalTicketGrantingTickets);
            sessionsMap.put("totalTickets", totalTicketGrantingTickets + totalProxyGrantingTickets);
            sessionsMap.put("totalPrincipals", uniquePrincipals.size());
            sessionsMap.put("totalUsageCount", totalUsageCount);
            return sessionsMap;
        };
        long timeout = Beans.newDuration((String)this.casProperties.getHttpClient().getAsyncTimeout()).toMillis();
        return new WebAsyncTask(timeout, asyncTask);
    }

    @PostMapping(value={"/destroySsoSession"})
    @ResponseBody
    public Map<String, Object> destroySsoSession(@RequestParam String ticketGrantingTicket, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        try {
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            sessionsMap.put(STATUS, 200);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            sessionsMap.put(STATUS, 500);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
            sessionsMap.put("message", e.getMessage());
        }
        return sessionsMap;
    }

    @PostMapping(value={"/destroySsoSessions"})
    @ResponseBody
    public Map<String, Object> destroySsoSessions(@RequestParam(defaultValue="ALL") String type, HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        HashMap failedTickets = new HashMap();
        SsoSessionReportOptions option = SsoSessionReportOptions.valueOf(type);
        Collection<Map<String, Object>> collection = this.getActiveSsoSessions(option);
        collection.stream().map(sso -> sso.get(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.getAttributeKey()).toString()).forEach(ticketGrantingTicket -> {
            try {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                failedTickets.put(ticketGrantingTicket, e.getMessage());
            }
        });
        if (failedTickets.isEmpty()) {
            sessionsMap.put(STATUS, 200);
        } else {
            sessionsMap.put(STATUS, 500);
            sessionsMap.put("failedTicketGrantingTickets", failedTickets);
        }
        return sessionsMap;
    }

    @GetMapping
    public ModelAndView showSsoSessions(HttpServletRequest request, HttpServletResponse response) {
        this.ensureEndpointAccessIsAuthorized(request, response);
        return new ModelAndView(VIEW_SSO_SESSIONS);
    }

    @Generated
    public String toString() {
        return "SingleSignOnSessionsReportController(centralAuthenticationService=" + this.centralAuthenticationService + ")";
    }

    @Generated
    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    private static enum SsoSessionAttributeKeys {
        AUTHENTICATED_PRINCIPAL("authenticated_principal"),
        PRINCIPAL_ATTRIBUTES("principal_attributes"),
        AUTHENTICATION_DATE("authentication_date"),
        AUTHENTICATION_DATE_FORMATTED("authentication_date_formatted"),
        TICKET_GRANTING_TICKET("ticket_granting_ticket"),
        AUTHENTICATION_ATTRIBUTES("authentication_attributes"),
        PROXIED_BY("proxied_by"),
        AUTHENTICATED_SERVICES("authenticated_services"),
        IS_PROXIED("is_proxied"),
        NUMBER_OF_USES("number_of_uses");

        private final String attributeKey;

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Generated
        public String getAttributeKey() {
            return this.attributeKey;
        }
    }

    private static enum SsoSessionReportOptions {
        ALL("all"),
        PROXIED("proxied"),
        DIRECT("direct");

        private final String type;

        private SsoSessionReportOptions(String type) {
            this.type = type;
        }
    }
}

