/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;

public class SpringWebflowReportController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringWebflowReportController.class);

    public SpringWebflowReportController(CasConfigurationProperties casProperties) {
        super("swfReport", "/swf", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getSpringWebflowReport(), casProperties);
    }

    @GetMapping(produces={"application/json"})
    @ResponseBody
    public Map<?, ?> getReport() {
        HashMap jsonMap = new HashMap();
        Map map = this.applicationContext.getBeansOfType(FlowDefinitionRegistry.class, false, true);
        map.forEach((k, v) -> Arrays.stream(v.getFlowDefinitionIds()).forEach(id -> {
            String vars;
            HashMap<String, Object> flowDetails = new HashMap<String, Object>();
            Flow def = (Flow)Flow.class.cast(v.getFlowDefinition(id));
            HashMap states = new HashMap();
            Arrays.stream(def.getStateIds()).forEach(st -> {
                List acts;
                State state = (State)def.getState(st);
                HashMap<String, Object> stateMap = new HashMap<String, Object>();
                if (!state.getAttributes().asMap().isEmpty()) {
                    stateMap.put("attributes", CollectionUtils.wrap((Object)state.getAttributes()));
                }
                if (StringUtils.isNotBlank((CharSequence)state.getCaption())) {
                    stateMap.put("caption", state.getCaption());
                }
                if (!(acts = StreamSupport.stream(state.getEntryActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList())).isEmpty()) {
                    stateMap.put("entryActions", acts);
                }
                if (state instanceof EndState) {
                    stateMap.put("isEndState", Boolean.TRUE);
                }
                if (state.isViewState()) {
                    Field field;
                    stateMap.put("isViewState", state.isViewState());
                    stateMap.put("isRedirect", ((ViewState)state).getRedirect());
                    acts = StreamSupport.stream(state.getEntryActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList());
                    if (!acts.isEmpty()) {
                        stateMap.put("renderActions", ((ViewState)state).getRenderActionList());
                    }
                    if (!(acts = Arrays.stream(((ViewState)state).getVariables()).map(value -> value.getName() + " -> " + value.getValueFactory().toString()).collect(Collectors.toList())).isEmpty()) {
                        stateMap.put("viewVariables", acts);
                    }
                    if ((field = ReflectionUtils.findField(((ViewState)state).getViewFactory().getClass(), (String)"viewId")) != null) {
                        ReflectionUtils.makeAccessible((Field)field);
                        Expression exp = (Expression)ReflectionUtils.getField((Field)field, (Object)((ViewState)state).getViewFactory());
                        stateMap.put("viewId", StringUtils.defaultIfBlank((CharSequence)exp.getExpressionString(), (CharSequence)exp.getValue(null).toString()));
                    } else {
                        LOGGER.warn("Field viewId cannot be located on view state [{}]", (Object)state);
                    }
                }
                if (state instanceof TransitionableState) {
                    TransitionableState stDef = (TransitionableState)TransitionableState.class.cast(state);
                    acts = StreamSupport.stream(stDef.getExitActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList());
                    if (!acts.isEmpty()) {
                        stateMap.put("exitActions", acts);
                    }
                    if (!(acts = Arrays.stream(stDef.getTransitions()).map(tr -> tr.getId() + " -> " + tr.getTargetStateId()).collect(Collectors.toList())).isEmpty()) {
                        stateMap.put("transitions", acts);
                    }
                }
                states.put(st, stateMap);
            });
            flowDetails.put("states", states);
            flowDetails.put("startState", def.getStartState().getId());
            flowDetails.put("possibleOutcomes", def.getPossibleOutcomes());
            flowDetails.put("stateCount", def.getStateCount());
            List acts = StreamSupport.stream(def.getEndActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList());
            if (!acts.isEmpty()) {
                flowDetails.put("endActions", acts);
            }
            if (!(acts = StreamSupport.stream(def.getGlobalTransitionSet().spliterator(), false).map(tr -> tr.getId() + " -> " + tr.getTargetStateId() + " @ " + tr.getExecutionCriteria().toString()).collect(Collectors.toList())).isEmpty()) {
                flowDetails.put("globalTransitions", acts);
            }
            if (!(acts = Arrays.stream(def.getExceptionHandlerSet().toArray()).map(Object::toString).collect(Collectors.toList())).isEmpty()) {
                flowDetails.put("exceptionHandlers", acts);
            }
            if (StringUtils.isNotBlank((CharSequence)(vars = Arrays.stream(def.getVariables()).map(FlowVariable::getName).collect(Collectors.joining(","))))) {
                flowDetails.put("variables", vars);
            }
            jsonMap.put(id, flowDetails);
        }));
        return jsonMap;
    }
}

