/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.util.CasVersion;
import org.apereo.cas.util.InetAddressUtils;
import org.apereo.cas.web.BaseCasMvcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class StatusController
extends BaseCasMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusController.class);
    private final HealthEndpoint healthEndpoint;

    public StatusController(CasConfigurationProperties casProperties, HealthEndpoint healthEndpoint) {
        super("status", "", (MonitorProperties.BaseEndpoint)casProperties.getMonitor().getEndpoints().getStatus(), casProperties);
        this.healthEndpoint = healthEndpoint;
    }

    @GetMapping
    @ResponseBody
    protected void handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.ensureEndpointAccessIsAuthorized(request, response);
        StringBuilder sb = new StringBuilder();
        Health health = this.healthEndpoint.invoke();
        Status status = health.getStatus();
        if (status.equals((Object)Status.DOWN) || status.equals((Object)Status.OUT_OF_SERVICE)) {
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        sb.append("Health: ").append(status.getCode());
        sb.append("\n\nHost:\t\t").append(StringUtils.isBlank((CharSequence)this.casProperties.getHost().getName()) ? InetAddressUtils.getCasServerHostName() : this.casProperties.getHost().getName());
        sb.append("\nServer:\t\t").append(this.casProperties.getServer().getName());
        sb.append("\nVersion:\t").append(CasVersion.getVersion());
        response.setContentType("text/plain");
        try (PrintWriter writer = response.getWriter();){
            IOUtils.copy((InputStream)new ByteArrayInputStream(sb.toString().getBytes(response.getCharacterEncoding())), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            ((Writer)writer).flush();
        }
    }
}

