/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import lombok.Generated;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.discovery.CasServerProfileRegistrar;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.report.AuthenticationEventsController;
import org.apereo.cas.web.report.CasInfoEndpointContributor;
import org.apereo.cas.web.report.CasServerDiscoveryProfileController;
import org.apereo.cas.web.report.ConfigurationStateController;
import org.apereo.cas.web.report.DashboardController;
import org.apereo.cas.web.report.LoggingConfigController;
import org.apereo.cas.web.report.LoggingOutputTailingService;
import org.apereo.cas.web.report.MetricsController;
import org.apereo.cas.web.report.PersonDirectoryAttributeResolutionController;
import org.apereo.cas.web.report.RegisteredServicesReportController;
import org.apereo.cas.web.report.SingleSignOnSessionStatusController;
import org.apereo.cas.web.report.SingleSignOnSessionsReportController;
import org.apereo.cas.web.report.SpringWebflowReportController;
import org.apereo.cas.web.report.StatisticsController;
import org.apereo.cas.web.report.StatusController;
import org.apereo.cas.web.report.TrustedDevicesController;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.View;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@Configuration(value="casReportsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableWebSocketMessageBroker
public class CasReportsConfiguration
extends AbstractWebSocketMessageBrokerConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasReportsConfiguration.class);
    private static final int LOG_TAILING_CORE_POOL_SIZE = 5;
    private static final int LOG_TAILING_QUEUE_CAPACITY = 25;
    @Autowired
    private Environment environment;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="cas3ServiceSuccessView")
    private View cas3ServiceSuccessView;
    @Autowired
    @Qualifier(value="cas3ServiceJsonView")
    private View cas3ServiceJsonView;
    @Autowired
    @Qualifier(value="cas2ServiceSuccessView")
    private View cas2ServiceSuccessView;
    @Autowired
    @Qualifier(value="cas1ServiceSuccessView")
    private View cas1ServiceSuccessView;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="principalFactory")
    private ObjectProvider<PrincipalFactory> principalFactory;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ObjectProvider<ServerProperties> serverProperties;
    @Autowired
    private ObjectProvider<HealthEndpoint> healthEndpoint;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="metrics")
    private MetricRegistry metricsRegistry;
    @Autowired
    @Qualifier(value="healthCheckMetrics")
    private HealthCheckRegistry healthCheckRegistry;

    @Bean
    public MvcEndpoint dashboardController() {
        return new DashboardController(this.casProperties);
    }

    @Bean
    public MvcEndpoint personDirectoryAttributeResolutionController() {
        return new PersonDirectoryAttributeResolutionController(this.casProperties, this.servicesManager, this.authenticationSystemSupport, this.personDirectoryPrincipalResolver, this.webApplicationServiceFactory, (PrincipalFactory)this.principalFactory.getIfAvailable(), this.cas3ServiceSuccessView, this.cas3ServiceJsonView, this.cas2ServiceSuccessView, this.cas1ServiceSuccessView);
    }

    @Profile(value={"standalone"})
    @ConditionalOnBean(name={"configurationPropertiesEnvironmentManager"})
    @Bean
    public MvcEndpoint internalConfigController() {
        return new ConfigurationStateController(this.casProperties);
    }

    @Bean
    public MvcEndpoint statusController() {
        return new StatusController(this.casProperties, (HealthEndpoint)this.healthEndpoint.getIfAvailable());
    }

    @Bean
    public MvcEndpoint singleSignOnSessionsReportController() {
        return new SingleSignOnSessionsReportController(this.centralAuthenticationService, this.casProperties);
    }

    @Bean
    public MvcEndpoint registeredServicesReportController() {
        return new RegisteredServicesReportController(this.casProperties, this.servicesManager);
    }

    @Bean
    @Autowired
    public MvcEndpoint loggingConfigController(@Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailManager) {
        return new LoggingConfigController(auditTrailManager, this.casProperties);
    }

    @Bean
    public MvcEndpoint ssoStatusController() {
        return new SingleSignOnSessionStatusController((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.ticketRegistrySupport, this.casProperties);
    }

    @Bean
    public MvcEndpoint swfReportController() {
        return new SpringWebflowReportController(this.casProperties);
    }

    @Autowired
    @Bean
    public MvcEndpoint statisticsController(@Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailManager) {
        return new StatisticsController(auditTrailManager, this.centralAuthenticationService, this.metricsRegistry, this.healthCheckRegistry, this.casProperties);
    }

    @Bean
    public MvcEndpoint metricsController() {
        return new MetricsController(this.casProperties);
    }

    @Bean
    public InfoContributor casInfoEndpointContributor() {
        return new CasInfoEndpointContributor();
    }

    @Bean
    public TaskExecutor logTailingTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setQueueCapacity(25);
        return executor;
    }

    @Autowired
    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"loggingOutputTailingService"})
    public TailerListener loggingOutputTailingService(SimpMessagingTemplate simpMessagingTemplate) {
        return new LoggingOutputTailingService(this.logTailingTaskExecutor(), simpMessagingTemplate, this.environment, this.resourceLoader);
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
        String contextPath = ((ServerProperties)this.serverProperties.getIfAvailable()).getContextPath();
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            config.setApplicationDestinationPrefixes(new String[]{contextPath});
        }
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/reports-websocket"}).addInterceptors(new HandshakeInterceptor[]{new HttpSessionHandshakeInterceptor()}).withSockJS();
    }

    @ConditionalOnClass(value={CasServerProfileRegistrar.class})
    @Configuration(value="serverDiscoveryProfileConfiguration")
    public class ServerDiscoveryProfileConfiguration {
        @Autowired
        @Bean
        public MvcEndpoint discoveryController(@Qualifier(value="casServerProfileRegistrar") CasServerProfileRegistrar casServerProfileRegistrar) {
            return new CasServerDiscoveryProfileController(CasReportsConfiguration.this.casProperties, CasReportsConfiguration.this.servicesManager, casServerProfileRegistrar);
        }
    }

    @ConditionalOnClass(value={CasEventRepository.class})
    @Configuration(value="authenticationEventsConfiguration")
    public class AuthenticationEventsConfiguration {
        @Autowired
        @Bean
        public MvcEndpoint authenticationEventsController(@Qualifier(value="casEventRepository") CasEventRepository eventRepository) {
            return new AuthenticationEventsController(eventRepository, CasReportsConfiguration.this.casProperties);
        }
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @Configuration(value="trustedDevicesConfiguration")
    public class TrustedDevicesConfiguration {
        @Autowired
        @Bean
        public MvcEndpoint trustedDevicesController(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine) {
            return new TrustedDevicesController(mfaTrustEngine, CasReportsConfiguration.this.casProperties);
        }
    }
}

