/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ThemeBasedViewResolver
implements ViewResolver,
Ordered {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeBasedViewResolver.class);
    private final ThemeResolver themeResolver;
    private final ThemeViewResolverFactory viewResolverFactory;
    private final Map<String, ViewResolver> resolvers = new ConcurrentHashMap<String, ViewResolver>();
    private int order = Integer.MAX_VALUE;

    public ThemeBasedViewResolver(ThemeResolver themeResolver, ThemeViewResolverFactory viewResolverFactory) {
        this.themeResolver = themeResolver;
        this.viewResolverFactory = viewResolverFactory;
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public View resolveViewName(String viewName, Locale locale) {
        Optional<String> theme = Optional.of(RequestContextHolder.currentRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest).map(arg_0 -> ((ThemeResolver)this.themeResolver).resolveThemeName(arg_0));
        try {
            Optional<ViewResolver> delegate = theme.map(this::getViewResolver);
            if (delegate.isPresent()) {
                return delegate.get().resolveViewName(viewName, locale);
            }
        }
        catch (Exception e) {
            LOGGER.debug("error resolving view '{}' for theme '{}'", new Object[]{viewName, theme.orElse(null), e});
        }
        return null;
    }

    private ViewResolver getViewResolver(String theme) {
        ViewResolver resolver;
        if (this.resolvers.containsKey(theme)) {
            resolver = this.resolvers.get(theme);
        } else {
            resolver = this.viewResolverFactory.create(theme);
            this.resolvers.put(theme, resolver);
        }
        return resolver;
    }

    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

