/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpCorsRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpHeadersRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpWebRequestProperties;
import org.apereo.cas.security.AddResponseHeadersFilter;
import org.apereo.cas.security.RequestParameterPolicyEnforcementFilter;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.support.RegisteredServiceResponseHeadersEnforcementFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.AuthenticationCredentialsThreadLocalBinderClearingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.CorsFilter;

@Configuration(value="casFiltersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasFiltersConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasFiltersConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ArgumentExtractor argumentExtractor;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;

    @RefreshScope
    @Bean
    @Lazy
    public FilterRegistrationBean characterEncodingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        HttpWebRequestProperties web = this.casProperties.getHttpWebRequest().getWeb();
        bean.setFilter((Filter)new CharacterEncodingFilter(web.getEncoding(), web.isForceEncoding()));
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("characterEncodingFilter");
        bean.setAsyncSupported(true);
        return bean;
    }

    @RefreshScope
    @Bean
    @Lazy
    public FilterRegistrationBean responseHeadersFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        AddResponseHeadersFilter filter = new AddResponseHeadersFilter();
        filter.setHeadersMap(this.casProperties.getHttpWebRequest().getCustomHeaders());
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("responseHeadersFilter");
        bean.setAsyncSupported(true);
        return bean;
    }

    @ConditionalOnProperty(prefix="cas.httpWebRequest.cors", name={"enabled"}, havingValue="true")
    @Bean
    @RefreshScope
    public FilterRegistrationBean casCorsFilter() {
        HttpCorsRequestProperties cors = this.casProperties.getHttpWebRequest().getCors();
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(cors.isAllowCredentials()));
        config.setAllowedOrigins(cors.getAllowOrigins());
        config.setAllowedMethods(cors.getAllowMethods());
        config.setAllowedHeaders(cors.getAllowHeaders());
        config.setMaxAge(Long.valueOf(cors.getMaxAge()));
        config.setExposedHeaders(cors.getExposedHeaders());
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setName("casCorsFilter");
        bean.setAsyncSupported(true);
        bean.setOrder(0);
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean responseHeadersSecurityFilter() {
        HttpHeadersRequestProperties header = this.casProperties.getHttpWebRequest().getHeader();
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("enableCacheControl", BooleanUtils.toStringTrueFalse((boolean)header.isCache()));
        initParams.put("enableXContentTypeOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXcontent()));
        initParams.put("enableStrictTransportSecurity", BooleanUtils.toStringTrueFalse((boolean)header.isHsts()));
        initParams.put("enableXFrameOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXframe()));
        initParams.put("XFrameOptions", header.getXframeOptions());
        initParams.put("enableXSSProtection", BooleanUtils.toStringTrueFalse((boolean)header.isXss()));
        initParams.put("XSSProtection", header.getXssOptions());
        if (StringUtils.isNotBlank((CharSequence)header.getContentSecurityPolicy())) {
            initParams.put("contentSecurityPolicy", header.getContentSecurityPolicy());
        }
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new RegisteredServiceResponseHeadersEnforcementFilter(this.servicesManager, this.argumentExtractor, this.authenticationRequestServiceSelectionStrategies));
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setInitParameters(initParams);
        bean.setName("responseHeadersSecurityFilter");
        bean.setAsyncSupported(true);
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean requestParameterSecurityFilter() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("parametersToCheck", this.casProperties.getHttpWebRequest().getParamsToCheck());
        initParams.put("charactersToForbid", "none");
        initParams.put("allowMultiValuedParameters", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().isAllowMultiValueParameters()));
        initParams.put("onlyPostParameters", this.casProperties.getHttpWebRequest().getOnlyPostParams());
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new RequestParameterPolicyEnforcementFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("requestParameterSecurityFilter");
        bean.setInitParameters(initParams);
        bean.setAsyncSupported(true);
        return bean;
    }

    @Bean
    public FilterRegistrationBean currentCredentialsAndAuthenticationClearingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new AuthenticationCredentialsThreadLocalBinderClearingFilter());
        bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
        bean.setName("currentCredentialsAndAuthenticationClearingFilter");
        bean.setAsyncSupported(true);
        return bean;
    }
}

