/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

import com.github.javaparser.Position;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import com.github.javaparser.utils.Utils;
import java.util.Deque;
import java.util.LinkedList;

public class SourcePrinter {
    private final String endOfLineCharacter;
    private final String indentation;
    private final int tabWidth;
    private final PrettyPrinterConfiguration.IndentType indentType;
    private final Deque<String> indents = new LinkedList<String>();
    private final StringBuilder buf = new StringBuilder();
    private Position cursor = new Position(1, 0);
    private boolean indented = false;

    SourcePrinter() {
        this(new PrettyPrinterConfiguration());
    }

    SourcePrinter(PrettyPrinterConfiguration configuration) {
        this.indentation = configuration.getIndent();
        this.endOfLineCharacter = configuration.getEndOfLineCharacter();
        this.tabWidth = configuration.getTabWidth();
        this.indentType = configuration.getIndentType();
        this.indents.push("");
    }

    public SourcePrinter indent() {
        String currentIndent = this.indents.peek();
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                this.indents.push(currentIndent + this.indentation);
                break;
            }
            case TABS: {
                this.indents.push(this.indentation + currentIndent);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return this;
    }

    public SourcePrinter indentWithAlignTo(int column) {
        this.indents.push(this.calculateIndentWithAlignTo(column));
        return this;
    }

    private String calculateIndentWithAlignTo(int column) {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("Indent/unindent calls are not well-balanced.");
        }
        String lastIndent = this.indents.peek();
        if (column < lastIndent.length()) {
            throw new IllegalStateException("Attempt to indent less than the previous indent.");
        }
        StringBuilder newIndent = new StringBuilder(lastIndent);
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                while (newIndent.length() < column) {
                    newIndent.append(' ');
                }
                break;
            }
            case TABS: {
                int logicalIndentLength = newIndent.length();
                while (logicalIndentLength + this.tabWidth <= column) {
                    newIndent.insert(0, '\t');
                    logicalIndentLength += this.tabWidth;
                }
                while (logicalIndentLength < column) {
                    newIndent.append(' ');
                    ++logicalIndentLength;
                }
                StringBuilder fullTab = new StringBuilder();
                for (int i = 0; i < this.tabWidth; ++i) {
                    fullTab.append(' ');
                }
                String fullTabString = fullTab.toString();
                if (newIndent.length() < this.tabWidth || !newIndent.substring(newIndent.length() - this.tabWidth).equals(fullTabString)) break;
                int i = newIndent.indexOf(fullTabString);
                newIndent.replace(i, i + this.tabWidth, "\t");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return newIndent.toString();
    }

    public SourcePrinter unindent() {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("Indent/unindent calls are not well-balanced.");
        }
        this.indents.pop();
        return this;
    }

    private void append(String arg) {
        this.buf.append(arg);
        this.cursor = this.cursor.withColumn(this.cursor.column + arg.length());
    }

    public SourcePrinter print(String arg) {
        if (!this.indented) {
            this.append(this.indents.peek());
            this.indented = true;
        }
        this.append(arg);
        return this;
    }

    public SourcePrinter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public SourcePrinter println() {
        this.buf.append(this.endOfLineCharacter);
        this.cursor = Position.pos(this.cursor.line + 1, 0);
        this.indented = false;
        return this;
    }

    public Position getCursor() {
        return this.cursor;
    }

    public String getSource() {
        return this.buf.toString();
    }

    public String toString() {
        return this.getSource();
    }

    public String normalizeEolInTextBlock(String content) {
        return Utils.normalizeEolInTextBlock(content, this.endOfLineCharacter);
    }

    public void reindentWithAlignToCursor() {
        String newIndent = this.calculateIndentWithAlignTo(this.cursor.column);
        this.indents.pop();
        this.indents.push(newIndent);
    }

    public void duplicateIndent() {
        this.indents.push(this.indents.peek());
    }
}

