/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import org.ldaptive.control.ControlFactory;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.provider.ControlHandler;

public class UnboundIDControlHandler
implements ControlHandler<Control> {
    public Class<Control> getControlType() {
        return Control.class;
    }

    public String getOID(Control control) {
        return control.getOID();
    }

    public Control handleRequest(RequestControl requestControl) {
        byte[] value = requestControl.encode();
        if (value == null) {
            return new Control(requestControl.getOID(), requestControl.getCriticality());
        }
        return new Control(requestControl.getOID(), requestControl.getCriticality(), new ASN1OctetString(value));
    }

    public ResponseControl handleResponse(Control responseControl) {
        return ControlFactory.createResponseControl((String)responseControl.getOID(), (boolean)responseControl.isCritical(), (byte[])responseControl.getValue().getValue());
    }
}

