/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.services.persondir.support.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.apereo.services.persondir.support.IUsernameAttributeProvider;
import org.apereo.services.persondir.support.NamedPersonImpl;
import org.apereo.services.persondir.support.xml.CachingJaxbLoader;
import org.apereo.services.persondir.support.xml.CachingJaxbLoaderImpl;
import org.apereo.services.persondir.support.xml.om.Attribute;
import org.apereo.services.persondir.support.xml.om.Person;
import org.apereo.services.persondir.support.xml.om.PersonData;
import org.apereo.services.persondir.util.PatternHelper;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class XmlPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao
implements InitializingBean {
    private final AttributeLoader attributeLoader = new AttributeLoader();
    private Set<String> attributesCache = null;
    private Map<String, Set<IPersonAttributes>> personByAttributeCache = null;
    private Map<String, IPersonAttributes> personByNameCache = null;
    private CachingJaxbLoader<PersonData> jaxbLoader;
    private Resource mappedXmlResource;

    public CachingJaxbLoader<PersonData> getJaxbLoader() {
        return this.jaxbLoader;
    }

    public void setJaxbLoader(CachingJaxbLoader<PersonData> jaxbLoader) {
        this.jaxbLoader = jaxbLoader;
    }

    public Resource getMappedXmlResource() {
        return this.mappedXmlResource;
    }

    public void setMappedXmlResource(Resource mappedXmlResource) {
        this.mappedXmlResource = mappedXmlResource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jaxbLoader == null && this.mappedXmlResource == null) {
            throw new BeanCreationException("Either the 'jaxbLoader' property or the 'mappedXmlResource' property needs to be set");
        }
        if (this.jaxbLoader == null) {
            this.jaxbLoader = new CachingJaxbLoaderImpl<PersonData>(PersonData.class);
            ((CachingJaxbLoaderImpl)this.jaxbLoader).setMappedXmlResource(this.mappedXmlResource);
        }
    }

    public Set<String> getAvailableQueryAttributes() {
        this.jaxbLoader.getUnmarshalledObject(this.attributeLoader);
        return this.attributesCache;
    }

    public Set<String> getPossibleUserAttributeNames() {
        this.jaxbLoader.getUnmarshalledObject(this.attributeLoader);
        return this.attributesCache;
    }

    @Override
    public IPersonAttributes getPerson(String uid) {
        this.jaxbLoader.getUnmarshalledObject(this.attributeLoader);
        return this.personByNameCache.get(uid);
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        this.jaxbLoader.getUnmarshalledObject(this.attributeLoader);
        LinkedHashMap canidatePersons = new LinkedHashMap();
        boolean firstAttribute = true;
        for (Map.Entry<String, List<Object>> queryEntry : query.entrySet()) {
            String entryKey = queryEntry.getKey();
            if (!this.attributesCache.contains(entryKey)) continue;
            LinkedList<String> entryValues = new LinkedList<String>();
            for (Object entryValue : queryEntry.getValue()) {
                String entry;
                if (entryValue == null || StringUtils.isBlank((CharSequence)(entry = entryValue.toString()))) continue;
                entryValues.add(entry);
            }
            if (entryValues.size() == 0) continue;
            Set<IPersonAttributes> personsForAttribute = this.personByAttributeCache.get(entryKey);
            Iterator canidateItr = canidatePersons.values().iterator();
            while (canidateItr.hasNext()) {
                IPersonAttributes canidate = (IPersonAttributes)canidateItr.next();
                if (personsForAttribute.contains(canidate)) continue;
                canidateItr.remove();
            }
            LinkedHashMap<String, IPersonAttributes> attributeCanidatePersons = new LinkedHashMap<String, IPersonAttributes>();
            HashSet<String> attributeMissPersons = new HashSet<String>();
            for (String queryString : entryValues) {
                Pattern queryPattern = PatternHelper.compilePattern(queryString);
                for (IPersonAttributes person : personsForAttribute) {
                    String name = person.getName();
                    if (!firstAttribute && !canidatePersons.containsKey(name)) continue;
                    boolean foundMatch = false;
                    List personAttributeValues = person.getAttributeValues(entryKey);
                    if (personAttributeValues != null) {
                        for (Object personAttributeValue : personAttributeValues) {
                            String personAttributeString;
                            Matcher personAttributeMatcher;
                            if (personAttributeValue == null || !(personAttributeMatcher = queryPattern.matcher(personAttributeString = personAttributeValue.toString())).matches()) continue;
                            attributeCanidatePersons.put(name, person);
                            attributeMissPersons.remove(name);
                            foundMatch = true;
                            break;
                        }
                    }
                    if (foundMatch || attributeCanidatePersons.containsKey(name)) continue;
                    attributeMissPersons.add(name);
                }
            }
            canidatePersons.putAll(attributeCanidatePersons);
            for (String userName : attributeMissPersons) {
                canidatePersons.remove(userName);
            }
            firstAttribute = false;
            if (canidatePersons.size() != 0) continue;
            break;
        }
        return new LinkedHashSet<IPersonAttributes>(canidatePersons.values());
    }

    private class AttributeLoader
    implements CachingJaxbLoader.UnmarshallingCallback<PersonData> {
        private AttributeLoader() {
        }

        @Override
        public synchronized void postProcessUnmarshalling(PersonData unmarshalledObject) {
            LinkedHashSet<String> attributeNames = new LinkedHashSet<String>();
            LinkedHashMap<String, LinkedHashSet<NamedPersonImpl>> personByAttributeCache = new LinkedHashMap<String, LinkedHashSet<NamedPersonImpl>>();
            LinkedHashMap<String, NamedPersonImpl> personByNameCache = new LinkedHashMap<String, NamedPersonImpl>();
            IUsernameAttributeProvider usernameAttributeProvider = XmlPersonAttributeDao.this.getUsernameAttributeProvider();
            String usernameAttribute = usernameAttributeProvider.getUsernameAttribute();
            attributeNames.add(usernameAttribute);
            for (Person xmlPerson : unmarshalledObject.getPerson()) {
                LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
                for (Attribute xmlAttribute : xmlPerson.getAttribute()) {
                    String key = xmlAttribute.getKey();
                    attributeNames.add(key);
                    attributes.put(key, new ArrayList<String>(xmlAttribute.getValue()));
                }
                NamedPersonImpl personAttributes = new NamedPersonImpl(xmlPerson.getName(), attributes);
                personByNameCache.put(personAttributes.getName(), personAttributes);
                for (String key : personAttributes.getAttributes().keySet()) {
                    LinkedHashSet<NamedPersonImpl> personsForAttribute = (LinkedHashSet<NamedPersonImpl>)personByAttributeCache.get(key);
                    if (personsForAttribute == null) {
                        personsForAttribute = new LinkedHashSet<NamedPersonImpl>();
                        personByAttributeCache.put(key, personsForAttribute);
                    }
                    personsForAttribute.add(personAttributes);
                }
            }
            XmlPersonAttributeDao.this.attributesCache = Collections.unmodifiableSet(attributeNames);
            XmlPersonAttributeDao.this.personByAttributeCache = Collections.unmodifiableMap(personByAttributeCache);
            XmlPersonAttributeDao.this.personByNameCache = Collections.unmodifiableMap(personByNameCache);
        }
    }
}

