/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.integration.channel.interceptor.VetoCapableInterceptor;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public final class GlobalChannelInterceptorProcessor
implements BeanFactoryAware,
SmartInitializingSingleton,
BeanPostProcessor {
    private static final Log logger = LogFactory.getLog(GlobalChannelInterceptorProcessor.class);
    private final OrderComparator comparator = new OrderComparator();
    private final Set<GlobalChannelInterceptorWrapper> positiveOrderInterceptors = new LinkedHashSet<GlobalChannelInterceptorWrapper>();
    private final Set<GlobalChannelInterceptorWrapper> negativeOrderInterceptors = new LinkedHashSet<GlobalChannelInterceptorWrapper>();
    private ListableBeanFactory beanFactory;
    private volatile boolean singletonsInstantiated;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterSingletonsInstantiated() {
        Collection interceptors = this.beanFactory.getBeansOfType(GlobalChannelInterceptorWrapper.class).values();
        if (CollectionUtils.isEmpty(interceptors)) {
            logger.debug((Object)"No global channel interceptors.");
        } else {
            for (GlobalChannelInterceptorWrapper channelInterceptor : interceptors) {
                if (channelInterceptor.getOrder() >= 0) {
                    this.positiveOrderInterceptors.add(channelInterceptor);
                    continue;
                }
                this.negativeOrderInterceptors.add(channelInterceptor);
            }
            Map channels = this.beanFactory.getBeansOfType(ChannelInterceptorAware.class);
            for (Map.Entry entry : channels.entrySet()) {
                this.addMatchingInterceptors((ChannelInterceptorAware)entry.getValue(), (String)entry.getKey());
            }
        }
        Properties integrationProperties = IntegrationContextUtils.getIntegrationProperties((BeanFactory)this.beanFactory);
        this.singletonsInstantiated = Boolean.parseBoolean(integrationProperties.getProperty("spring.integration.postProcessDynamicBeans"));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.singletonsInstantiated && bean instanceof ChannelInterceptorAware) {
            this.addMatchingInterceptors((ChannelInterceptorAware)bean, beanName);
        }
        return bean;
    }

    public void addMatchingInterceptors(ChannelInterceptorAware channel, String beanName) {
        String[] patterns;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applying global interceptors on channel '" + beanName + "'"));
        }
        ArrayList<GlobalChannelInterceptorWrapper> tempInterceptors = new ArrayList<GlobalChannelInterceptorWrapper>();
        for (GlobalChannelInterceptorWrapper globalChannelInterceptorWrapper : this.positiveOrderInterceptors) {
            patterns = globalChannelInterceptorWrapper.getPatterns();
            if (!PatternMatchUtils.simpleMatch((String[])(patterns = StringUtils.trimArrayElements((String[])patterns)), (String)beanName)) continue;
            tempInterceptors.add(globalChannelInterceptorWrapper);
        }
        Collections.sort(tempInterceptors, this.comparator);
        for (GlobalChannelInterceptorWrapper next : tempInterceptors) {
            ChannelInterceptor channelInterceptor = next.getChannelInterceptor();
            if (channelInterceptor instanceof VetoCapableInterceptor && !((VetoCapableInterceptor)channelInterceptor).shouldIntercept(beanName, channel)) continue;
            channel.addInterceptor(channelInterceptor);
        }
        tempInterceptors.clear();
        for (GlobalChannelInterceptorWrapper globalChannelInterceptorWrapper : this.negativeOrderInterceptors) {
            patterns = globalChannelInterceptorWrapper.getPatterns();
            if (!PatternMatchUtils.simpleMatch((String[])(patterns = StringUtils.trimArrayElements((String[])patterns)), (String)beanName)) continue;
            tempInterceptors.add(globalChannelInterceptorWrapper);
        }
        Collections.sort(tempInterceptors, this.comparator);
        if (!tempInterceptors.isEmpty()) {
            for (int i = tempInterceptors.size() - 1; i >= 0; --i) {
                ChannelInterceptor channelInterceptor = ((GlobalChannelInterceptorWrapper)tempInterceptors.get(i)).getChannelInterceptor();
                if (channelInterceptor instanceof VetoCapableInterceptor && !((VetoCapableInterceptor)channelInterceptor).shouldIntercept(beanName, channel)) continue;
                channel.addInterceptor(0, channelInterceptor);
            }
        }
    }
}

